/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.base.Supplier;
import com.google.common.cache.CacheStats;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.segment.RecordId;

public abstract class RecordCache<T> {
    private long hitCount;
    private long missCount;
    private long loadCount;
    private long evictionCount;

    public abstract void put(@Nonnull T var1, @Nonnull RecordId var2);

    @CheckForNull
    public abstract RecordId get(@Nonnull T var1);

    public abstract long size();

    public CacheStats getStats() {
        return new CacheStats(this.hitCount, this.missCount, this.loadCount, 0L, 0L, this.evictionCount);
    }

    @Nonnull
    public static <T> RecordCache<T> newRecordCache(int size) {
        if (size <= 0) {
            return new Empty();
        }
        return new Default(size);
    }

    @Nonnull
    public static <T> Supplier<RecordCache<T>> factory(int size) {
        if (size <= 0) {
            return Empty.emptyFactory();
        }
        return Default.defaultFactory(size);
    }

    private static class Default<T>
    extends RecordCache<T> {
        private final Map<T, RecordId> records;

        static final <T> Supplier<RecordCache<T>> defaultFactory(final int size) {
            return new Supplier<RecordCache<T>>(){

                public RecordCache<T> get() {
                    return new Default(size);
                }
            };
        }

        Default(final int size) {
            this.records = new LinkedHashMap<T, RecordId>(size * 4 / 3, 0.75f, true){

                @Override
                protected boolean removeEldestEntry(Map.Entry<T, RecordId> eldest) {
                    boolean remove;
                    boolean bl = remove = super.size() > size;
                    if (remove) {
                        ((RecordCache)Default.this).evictionCount++;
                    }
                    return remove;
                }
            };
        }

        @Override
        public synchronized void put(@Nonnull T key, @Nonnull RecordId value) {
            ((RecordCache)this).loadCount++;
            this.records.put(key, value);
        }

        @Override
        public synchronized RecordId get(@Nonnull T key) {
            RecordId value = this.records.get(key);
            if (value == null) {
                ((RecordCache)this).missCount++;
            } else {
                ((RecordCache)this).hitCount++;
            }
            return value;
        }

        @Override
        public synchronized long size() {
            return this.records.size();
        }
    }

    private static class Empty<T>
    extends RecordCache<T> {
        private Empty() {
        }

        static final <T> Supplier<RecordCache<T>> emptyFactory() {
            return new Supplier<RecordCache<T>>(){

                public RecordCache<T> get() {
                    return new Empty();
                }
            };
        }

        @Override
        public synchronized void put(@Nonnull T key, @Nonnull RecordId value) {
        }

        @Override
        public synchronized RecordId get(@Nonnull T key) {
            ((RecordCache)this).missCount++;
            return null;
        }

        @Override
        public long size() {
            return 0L;
        }
    }
}

