/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.cache.Weigher;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.cache.CacheLIRS;
import org.apache.jackrabbit.oak.cache.CacheStats;

public abstract class ReaderCache<T> {
    @Nonnull
    private final Weigher<CacheKey<T>, T> weigher = new Weigher<CacheKey<T>, T>(){

        public int weigh(CacheKey<T> key, T value) {
            return ReaderCache.this.getEntryWeight(value);
        }
    };
    @Nonnull
    private final String name;
    @CheckForNull
    private final FastCache<T> fastCache;
    @Nonnull
    private final CacheLIRS<CacheKey<T>, T> cache;

    protected ReaderCache(long maxWeight, int averageWeight, @Nonnull String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.fastCache = new FastCache();
        this.cache = CacheLIRS.newBuilder().module(name).maximumWeight(maxWeight).averageWeight(averageWeight).weigher(this.weigher).build();
    }

    @Nonnull
    public CacheStats getStats() {
        return new CacheStats(this.cache, this.name, this.weigher, this.cache.getMaxMemory());
    }

    private static int getEntryHash(long lsb, long msb, int offset) {
        int hash = (int)(msb ^ lsb) + offset;
        hash = (hash >>> 16 ^ hash) * 73244475;
        return hash >>> 16 ^ hash;
    }

    @Nonnull
    public T get(long msb, long lsb, int offset, Function<Integer, T> loader) {
        int hash = ReaderCache.getEntryHash(msb, lsb, offset);
        if (this.fastCache == null) {
            Object value = loader.apply((Object)offset);
            assert (value != null);
            return (T)value;
        }
        Object value = this.fastCache.get(hash, msb, lsb, offset);
        if (value != null) {
            return value;
        }
        CacheKey key = new CacheKey(hash, msb, lsb, offset);
        value = this.cache.getIfPresent(key);
        if (value == null) {
            value = loader.apply((Object)offset);
            assert (value != null);
            this.cache.put(key, value);
        }
        if (this.isSmall(value)) {
            this.fastCache.put(hash, new FastCacheEntry<T>(hash, msb, lsb, offset, value));
        }
        return value;
    }

    public void clear() {
        if (this.fastCache != null) {
            this.cache.invalidateAll();
            this.fastCache.clear();
        }
    }

    protected abstract int getEntryWeight(T var1);

    protected abstract boolean isSmall(T var1);

    private static class FastCacheEntry<T> {
        private final int hash;
        private final long msb;
        private final long lsb;
        private final int offset;
        private final T value;

        FastCacheEntry(int hash, long msb, long lsb, int offset, T value) {
            this.hash = hash;
            this.msb = msb;
            this.lsb = lsb;
            this.offset = offset;
            this.value = value;
        }

        boolean matches(long msb, long lsb, int offset) {
            return this.offset == offset && this.msb == msb && this.lsb == lsb;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof FastCacheEntry)) {
                return false;
            }
            FastCacheEntry o = (FastCacheEntry)other;
            return o.hash == this.hash && o.msb == this.msb && o.lsb == this.lsb && o.offset == this.offset;
        }
    }

    private static class CacheKey<T> {
        private final int hash;
        private final long msb;
        private final long lsb;
        private final int offset;

        CacheKey(int hash, long msb, long lsb, int offset) {
            this.hash = hash;
            this.msb = msb;
            this.lsb = lsb;
            this.offset = offset;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof CacheKey)) {
                return false;
            }
            CacheKey o = (CacheKey)other;
            return o.hash == this.hash && o.msb == this.msb && o.lsb == this.lsb && o.offset == this.offset;
        }

        public String toString() {
            return Long.toHexString(this.msb) + ':' + Long.toHexString(this.lsb) + '+' + Integer.toHexString(this.offset);
        }
    }

    private static class FastCache<T> {
        private static final int CACHE_SIZE = 16384;
        private final FastCacheEntry<T>[] elements = new FastCacheEntry[16384];

        private FastCache() {
        }

        T get(int hash, long msb, long lsb, int offset) {
            int index = hash & 0x3FFF;
            FastCacheEntry<T> e = this.elements[index];
            if (e != null && e.matches(msb, lsb, offset)) {
                return (T)((FastCacheEntry)e).value;
            }
            return null;
        }

        void clear() {
            Arrays.fill(this.elements, null);
        }

        void put(int hash, FastCacheEntry<T> entry) {
            int index = hash & 0x3FFF;
            this.elements[index] = entry;
        }
    }
}

