/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.backup.impl;

import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.backup.FileStoreBackup;
import org.apache.jackrabbit.oak.segment.Compactor;
import org.apache.jackrabbit.oak.segment.Revisions;
import org.apache.jackrabbit.oak.segment.SegmentBufferWriter;
import org.apache.jackrabbit.oak.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.segment.SegmentReader;
import org.apache.jackrabbit.oak.segment.SegmentWriter;
import org.apache.jackrabbit.oak.segment.WriterCacheManager;
import org.apache.jackrabbit.oak.segment.compaction.SegmentGCOptions;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.file.FileStoreBuilder;
import org.apache.jackrabbit.oak.segment.file.InvalidFileStoreVersionException;
import org.apache.jackrabbit.oak.segment.file.tooling.BasicReadOnlyBlobStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStoreBackupImpl
implements FileStoreBackup {
    private static final Logger log = LoggerFactory.getLogger(FileStoreBackupImpl.class);
    public static boolean USE_FAKE_BLOBSTORE = Boolean.getBoolean("oak.backup.UseFakeBlobStore");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void backup(@Nonnull SegmentReader reader, @Nonnull Revisions revisions, @Nonnull File destination) throws IOException, InvalidFileStoreVersionException {
        Stopwatch watch = Stopwatch.createStarted();
        SegmentGCOptions gcOptions = SegmentGCOptions.defaultGCOptions().setOffline();
        FileStoreBuilder builder = FileStoreBuilder.fileStoreBuilder(destination).withDefaultMemoryMapping();
        if (USE_FAKE_BLOBSTORE) {
            builder.withBlobStore(new BasicReadOnlyBlobStore());
        }
        builder.withGCOptions(gcOptions);
        SegmentNodeState current = reader.readHeadState(revisions);
        try (FileStore backup = builder.build();){
            int gen = current.getRecordId().getSegmentId().getGcGeneration();
            SegmentBufferWriter bufferWriter = new SegmentBufferWriter(backup, backup.getTracker(), backup.getReader(), "b", gen);
            SegmentWriter writer = new SegmentWriter(backup, backup.getReader(), backup.getBlobStore(), new WriterCacheManager.Default(), bufferWriter, backup.getBinaryReferenceConsumer());
            Compactor compactor = new Compactor(backup.getReader(), writer, backup.getBlobStore(), (Supplier<Boolean>)Suppliers.ofInstance((Object)false), gcOptions);
            compactor.setContentEqualityCheck(true);
            SegmentNodeState head = backup.getHead();
            SegmentNodeState after = compactor.compact(head, current, head);
            if (after != null) {
                backup.getRevisions().setHead(head.getRecordId(), after.getRecordId(), new Revisions.Option[0]);
            }
        }
        backup = FileStoreBuilder.fileStoreBuilder(destination).withDefaultMemoryMapping().withGCOptions(gcOptions).build();
        try {
            this.cleanup(backup);
        }
        finally {
            backup.close();
        }
        watch.stop();
        log.info("Backup finished in {}.", (Object)watch);
    }

    @Override
    public boolean cleanup(FileStore f) throws IOException {
        f.cleanup();
        return true;
    }
}

