/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.jackrabbit.webdav.DavMethods;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSRFUtil {
    public static final String DISABLED = "disabled";
    public static final Set<String> CONTENT_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("application/x-www-form-urlencoded", "multipart/form-data", "text/plain")));
    private static final Logger log = LoggerFactory.getLogger(CSRFUtil.class);
    private final boolean disabled;
    private final Set<String> allowedReferrerHosts;

    public CSRFUtil(String config) {
        if (config == null || config.length() == 0) {
            this.disabled = false;
            this.allowedReferrerHosts = Collections.emptySet();
        } else if (DISABLED.equalsIgnoreCase(config.trim())) {
            this.disabled = true;
            this.allowedReferrerHosts = Collections.emptySet();
        } else {
            this.disabled = false;
            String[] allowed = config.split(",");
            this.allowedReferrerHosts = new HashSet<String>(allowed.length);
            for (String entry : allowed) {
                this.allowedReferrerHosts.add(entry.trim());
            }
        }
    }

    public boolean isValidRequest(HttpServletRequest request) throws MalformedURLException {
        int methodCode = DavMethods.getMethodCode(request.getMethod());
        if (this.disabled || 4 != methodCode || !CONTENT_TYPES.contains(request.getContentType())) {
            return true;
        }
        String refHeader = request.getHeader("Referer");
        if (refHeader == null) {
            return false;
        }
        String host = new URL(refHeader).getHost();
        return host.equals(request.getServerName()) || this.allowedReferrerHosts.contains(host);
    }
}

