/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.simpleframework.transport.Socket;
import org.simpleframework.transport.SocketBufferAppender;
import org.simpleframework.transport.TransportEvent;
import org.simpleframework.transport.TransportException;
import org.simpleframework.transport.trace.Trace;

class SocketBuffer {
    private SocketBufferAppender appender;
    private SocketChannel channel;
    private ByteBuffer reference;
    private Trace trace;
    private int chunk;
    private boolean closed;

    public SocketBuffer(Socket socket, int chunk, int limit) {
        this.appender = new SocketBufferAppender(socket, chunk, limit);
        this.channel = socket.getChannel();
        this.trace = socket.getTrace();
        this.chunk = chunk;
    }

    public synchronized boolean ready() throws IOException {
        if (this.closed) {
            throw new TransportException("Buffer has been closed");
        }
        if (this.reference != null) {
            int remaining = this.reference.remaining();
            if (remaining <= 0) {
                this.reference = null;
                return true;
            }
            return false;
        }
        return true;
    }

    public synchronized boolean write(ByteBuffer duplicate) throws IOException {
        if (this.closed) {
            throw new TransportException("Buffer has been closed");
        }
        if (this.reference != null) {
            throw new IOException("Buffer already pending write");
        }
        int count = this.appender.length();
        if (count > 0) {
            return this.merge(duplicate);
        }
        int remaining = duplicate.remaining();
        if (remaining < this.chunk) {
            this.appender.append(duplicate);
            return true;
        }
        if (!this.flush(duplicate)) {
            int space = this.appender.space();
            if (remaining < space) {
                this.appender.append(duplicate);
                return true;
            }
            this.reference = duplicate;
            return false;
        }
        return true;
    }

    private synchronized boolean merge(ByteBuffer duplicate) throws IOException {
        if (this.closed) {
            throw new TransportException("Buffer has been closed");
        }
        int count = this.appender.length();
        int merged = this.appender.append(duplicate);
        int payload = merged + count;
        if (payload >= this.chunk) {
            int written = this.appender.write(this.channel);
            if (written < payload) {
                this.reference = duplicate;
                return false;
            }
            return this.write(duplicate);
        }
        return true;
    }

    public synchronized boolean flush() throws IOException {
        int written;
        if (this.closed) {
            throw new TransportException("Buffer has been closed");
        }
        int count = this.appender.length();
        if (count > 0 && (written = this.appender.write(this.channel)) < count) {
            this.compact();
            return false;
        }
        if (this.reference != null) {
            if (!this.flush(this.reference)) {
                this.compact();
                return false;
            }
            this.reference = null;
        }
        return true;
    }

    private synchronized boolean flush(ByteBuffer segment) throws IOException {
        int count;
        int size;
        if (this.closed) {
            throw new TransportException("Buffer has been closed");
        }
        int require = segment.remaining();
        for (count = 0; count < require && (size = this.channel.write(segment)) > 0; count += size) {
            if (this.trace == null) continue;
            this.trace.trace((Object)TransportEvent.WRITE, size);
        }
        return count == require;
    }

    private synchronized void compact() throws IOException {
        int space;
        int remaining;
        if (this.closed) {
            throw new TransportException("Buffer has been closed");
        }
        if (this.reference != null && (remaining = this.reference.remaining()) < (space = this.appender.space())) {
            this.appender.append(this.reference);
            this.reference = null;
        }
    }

    public synchronized void close() throws IOException {
        if (this.closed) {
            throw new TransportException("Buffer has been closed");
        }
        if (!this.closed) {
            try {
                this.closed = true;
                this.trace.trace((Object)TransportEvent.CLOSE);
                this.channel.socket().shutdownOutput();
            }
            catch (Throwable cause) {
                this.trace.trace((Object)TransportEvent.ERROR, cause);
            }
            this.channel.close();
        }
    }
}

