/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.util;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.identifier.IdentifierManager;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.plugins.tree.impl.ImmutableTree;
import org.apache.jackrabbit.util.ISO8601;

public final class TreeUtil {
    private TreeUtil() {
    }

    @CheckForNull
    public static String getPrimaryTypeName(@Nonnull Tree tree) {
        return TreeUtil.getStringInternal(tree, "jcr:primaryType", Type.NAME);
    }

    @CheckForNull
    public static Iterable<String> getStrings(@Nonnull Tree tree, @Nonnull String propertyName) {
        PropertyState property = tree.getProperty(propertyName);
        if (property == null) {
            return null;
        }
        return property.getValue(Type.STRINGS);
    }

    @CheckForNull
    public static String getString(@Nonnull Tree tree, @Nonnull String propertyName) {
        return TreeUtil.getStringInternal(tree, propertyName, Type.STRING);
    }

    @CheckForNull
    private static String getStringInternal(@Nonnull Tree tree, @Nonnull String propertyName, @Nonnull Type<String> type) {
        PropertyState property = tree.getProperty(propertyName);
        if (property != null && !property.isArray()) {
            return property.getValue(type);
        }
        return null;
    }

    public static boolean getBoolean(@Nonnull Tree tree, @Nonnull String propertyName) {
        PropertyState property = tree.getProperty(propertyName);
        return property != null && !property.isArray() && property.getValue(Type.BOOLEAN) != false;
    }

    @CheckForNull
    public static String getName(@Nonnull Tree tree, @Nonnull String name) {
        PropertyState property = tree.getProperty(name);
        if (property != null && property.getType() == Type.NAME) {
            return property.getValue(Type.NAME);
        }
        return null;
    }

    @Nonnull
    public static Iterable<String> getNames(@Nonnull Tree tree, @Nonnull String name) {
        PropertyState property = tree.getProperty(name);
        if (property != null && property.getType() == Type.NAMES) {
            return property.getValue(Type.NAMES);
        }
        return Collections.emptyList();
    }

    @CheckForNull
    public static Tree getTree(@Nonnull Tree tree, @Nonnull String path) {
        for (String element : PathUtils.elements(path)) {
            if (PathUtils.denotesParent(element)) {
                if (tree.isRoot()) {
                    return null;
                }
                tree = tree.getParent();
                continue;
            }
            if (PathUtils.denotesCurrent(element)) continue;
            tree = tree.getChild(element);
        }
        return tree;
    }

    public static Tree addChild(@Nonnull Tree parent, @Nonnull String name, @CheckForNull String typeName, @Nonnull Tree typeRoot, @CheckForNull String userID) throws RepositoryException {
        if (typeName == null && (typeName = TreeUtil.getDefaultChildType(typeRoot, parent, name)) == null) {
            String path = PathUtils.concat(parent.getPath(), name);
            throw new ConstraintViolationException("No default node type available for " + path);
        }
        Tree type = typeRoot.getChild(typeName);
        if (!type.exists()) {
            throw new NoSuchNodeTypeException("Node type " + typeName + " does not exist");
        }
        if (TreeUtil.getBoolean(type, "jcr:isAbstract") && !typeName.equals(TreeUtil.getDefaultChildType(typeRoot, parent, name))) {
            throw new ConstraintViolationException("Node type " + typeName + " is abstract");
        }
        if (TreeUtil.getBoolean(type, "jcr:isMixin")) {
            throw new ConstraintViolationException("Node type " + typeName + " is a mixin type");
        }
        Tree child = parent.addChild(name);
        child.setProperty("jcr:primaryType", typeName, Type.NAME);
        if (TreeUtil.getBoolean(type, "jcr:hasOrderableChildNodes")) {
            child.setOrderableChildren(true);
        }
        TreeUtil.autoCreateItems(child, type, typeRoot, userID);
        return child;
    }

    public static void addMixin(@Nonnull Tree tree, @Nonnull String mixinName, @Nonnull Tree typeRoot, @CheckForNull String userID) throws RepositoryException {
        Tree type = typeRoot.getChild(mixinName);
        if (!type.exists()) {
            throw new NoSuchNodeTypeException("Node type " + mixinName + " does not exist");
        }
        if (TreeUtil.getBoolean(type, "jcr:isAbstract")) {
            throw new ConstraintViolationException("Node type " + mixinName + " is abstract");
        }
        if (!TreeUtil.getBoolean(type, "jcr:isMixin")) {
            throw new ConstraintViolationException("Node type " + mixinName + " is a not a mixin type");
        }
        ArrayList<String> mixins = Lists.newArrayList();
        String primary = TreeUtil.getName(tree, "jcr:primaryType");
        if (primary != null && Iterables.contains(TreeUtil.getNames(type, "rep:primarySubtypes"), primary)) {
            return;
        }
        HashSet<String> subMixins = Sets.newHashSet(TreeUtil.getNames(type, "rep:mixinSubtypes"));
        for (String mixin : TreeUtil.getNames(tree, "jcr:mixinTypes")) {
            if (mixinName.equals(mixin) || subMixins.contains(mixin)) {
                return;
            }
            mixins.add(mixin);
        }
        mixins.add(mixinName);
        tree.setProperty("jcr:mixinTypes", mixins, Type.NAMES);
        TreeUtil.autoCreateItems(tree, type, typeRoot, userID);
    }

    public static void autoCreateItems(@Nonnull Tree tree, @Nonnull Tree type, @Nonnull Tree typeRoot, @CheckForNull String userID) throws RepositoryException {
        Tree properties = type.getChild("rep:namedPropertyDefinitions");
        block0: for (Tree definitions : properties.getChildren()) {
            String name = definitions.getName();
            if (name.equals("rep:primaryType") || name.equals("rep:mixinTypes")) continue;
            if (name.equals("rep:uuid")) {
                name = "jcr:uuid";
            }
            for (Tree definition : definitions.getChildren()) {
                if (!TreeUtil.getBoolean(definition, "jcr:autoCreated")) continue;
                if (tree.hasProperty(name)) continue block0;
                PropertyState property = TreeUtil.autoCreateProperty(name, definition, userID);
                if (property != null) {
                    tree.setProperty(property);
                    continue block0;
                }
                throw new RepositoryException("Unable to auto-create value for " + PathUtils.concat(tree.getPath(), name));
            }
        }
        Tree childNodes = type.getChild("rep:namedChildNodeDefinitions");
        block2: for (Tree definitions : childNodes.getChildren()) {
            String name = definitions.getName();
            for (Tree definition : definitions.getChildren()) {
                if (!TreeUtil.getBoolean(definition, "jcr:autoCreated")) continue;
                if (tree.hasChild(name)) continue block2;
                String typeName = TreeUtil.getName(definition, "jcr:defaultPrimaryType");
                TreeUtil.addChild(tree, name, typeName, typeRoot, userID);
                continue block2;
            }
        }
    }

    public static PropertyState autoCreateProperty(@Nonnull String name, @Nonnull Tree definition, @CheckForNull String userID) {
        if ("jcr:uuid".equals(name)) {
            String uuid = IdentifierManager.generateUUID();
            return PropertyStates.createProperty(name, (Object)uuid, Type.STRING);
        }
        if ("jcr:created".equals(name)) {
            String now = ISO8601.format(Calendar.getInstance());
            return PropertyStates.createProperty(name, (Object)now, Type.DATE);
        }
        if ("jcr:createdBy".equals(name)) {
            return PropertyStates.createProperty(name, (Object)Strings.nullToEmpty(userID), Type.STRING);
        }
        if ("jcr:lastModified".equals(name)) {
            String now = ISO8601.format(Calendar.getInstance());
            return PropertyStates.createProperty(name, (Object)now, Type.DATE);
        }
        if ("jcr:lastModifiedBy".equals(name)) {
            return PropertyStates.createProperty(name, (Object)Strings.nullToEmpty(userID), Type.STRING);
        }
        PropertyState values = definition.getProperty("jcr:defaultValues");
        if (values != null) {
            Type<?> type = values.getType();
            if (TreeUtil.getBoolean(definition, "jcr:multiple")) {
                return PropertyStates.createProperty(name, values.getValue(type), type);
            }
            if (values.count() > 0) {
                type = type.getBaseType();
                return PropertyStates.createProperty(name, values.getValue(type, 0), type);
            }
        }
        return null;
    }

    public static String getDefaultChildType(Tree typeRoot, Tree parent, String childName) {
        String defaultName;
        Tree definitions;
        String name = PathUtils.dropIndexFromName(childName);
        boolean sns = !name.equals(childName);
        List<Tree> types = TreeUtil.getEffectiveType(parent, typeRoot);
        for (Tree type : types) {
            definitions = type.getChild("rep:namedChildNodeDefinitions").getChild(name);
            defaultName = TreeUtil.findDefaultPrimaryType(definitions, sns);
            if (defaultName == null) continue;
            return defaultName;
        }
        for (Tree type : types) {
            definitions = type.getChild("rep:residualChildNodeDefinitions");
            defaultName = TreeUtil.findDefaultPrimaryType(definitions, sns);
            if (defaultName == null) continue;
            return defaultName;
        }
        return null;
    }

    public static List<Tree> getEffectiveType(Tree tree, Tree typeRoot) {
        Tree type;
        ArrayList<Tree> types = Lists.newArrayList();
        String primary = TreeUtil.getName(tree, "jcr:primaryType");
        if (primary != null && (type = typeRoot.getChild(primary)).exists()) {
            types.add(type);
        }
        for (String mixin : TreeUtil.getNames(tree, "jcr:mixinTypes")) {
            Tree type2 = typeRoot.getChild(mixin);
            if (!type2.exists()) continue;
            types.add(type2);
        }
        return types;
    }

    public static String findDefaultPrimaryType(Tree definitions, boolean sns) {
        for (Tree definition : definitions.getChildren()) {
            String defaultName = TreeUtil.getName(definition, "jcr:defaultPrimaryType");
            if (defaultName == null || sns && !TreeUtil.getBoolean(definition, "jcr:sameNameSiblings")) continue;
            return defaultName;
        }
        return null;
    }

    public static boolean isNodeType(Tree tree, String typeName, Tree typeRoot) {
        Tree type;
        String primaryName = TreeUtil.getName(tree, "jcr:primaryType");
        if (typeName.equals(primaryName)) {
            return true;
        }
        if (primaryName != null && Iterables.contains(TreeUtil.getNames(type = typeRoot.getChild(primaryName), "rep:supertypes"), typeName)) {
            return true;
        }
        for (String mixinName : TreeUtil.getNames(tree, "jcr:mixinTypes")) {
            if (typeName.equals(mixinName)) {
                return true;
            }
            Tree type2 = typeRoot.getChild(mixinName);
            if (!Iterables.contains(TreeUtil.getNames(type2, "rep:supertypes"), typeName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isReadOnlyTree(@Nonnull Tree tree) {
        return tree instanceof ImmutableTree;
    }
}

