/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.upgrade.version;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class VersionHistoryUtil {
    public static String getRelativeVersionHistoryPath(String versionableUuid) {
        return Joiner.on('/').join(Iterables.concat(Collections.singleton(""), VersionHistoryUtil.getRelativeVersionHistoryPathSegments(versionableUuid), Collections.singleton(versionableUuid)));
    }

    static NodeState getVersionHistoryNodeState(NodeState versionStorage, String versionableUuid) {
        NodeState historyParent = versionStorage;
        for (String segment : VersionHistoryUtil.getRelativeVersionHistoryPathSegments(versionableUuid)) {
            historyParent = historyParent.getChildNode(segment);
        }
        return historyParent.getChildNode(versionableUuid);
    }

    static NodeBuilder getVersionHistoryBuilder(NodeBuilder versionStorage, String versionableUuid) {
        NodeBuilder history = versionStorage;
        for (String segment : VersionHistoryUtil.getRelativeVersionHistoryPathSegments(versionableUuid)) {
            history = history.getChildNode(segment);
        }
        return history.getChildNode(versionableUuid);
    }

    private static List<String> getRelativeVersionHistoryPathSegments(String versionableUuid) {
        ArrayList<String> segments = new ArrayList<String>();
        for (int i = 0; i < 3; ++i) {
            segments.add(versionableUuid.substring(i * 2, i * 2 + 2));
        }
        return segments;
    }

    public static NodeState getVersionStorage(NodeState root) {
        return root.getChildNode("jcr:system").getChildNode("jcr:versionStorage");
    }

    public static NodeBuilder getVersionStorage(NodeBuilder root) {
        return root.child("jcr:system").child("jcr:versionStorage");
    }
}

