/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.upgrade.version;

import java.util.Calendar;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.nodetype.TypePredicate;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.upgrade.DescendantsIterator;
import org.apache.jackrabbit.oak.upgrade.nodestate.NodeStateCopier;
import org.apache.jackrabbit.oak.upgrade.version.VersionCopyConfiguration;
import org.apache.jackrabbit.oak.upgrade.version.VersionHistoryUtil;
import org.apache.jackrabbit.util.ISO8601;

public class VersionCopier {
    private final TypePredicate isVersion;
    private final NodeState sourceVersionStorage;
    private final NodeBuilder targetVersionStorage;
    private final NodeBuilder targetRoot;

    public VersionCopier(NodeBuilder targetRoot, NodeState sourceVersionStorage, NodeBuilder targetVersionStorage) {
        this.isVersion = new TypePredicate(targetRoot.getNodeState(), "nt:version");
        this.sourceVersionStorage = sourceVersionStorage;
        this.targetVersionStorage = targetVersionStorage;
        this.targetRoot = targetRoot;
    }

    public static void copyVersionStorage(NodeBuilder targetRoot, NodeState sourceVersionStorage, NodeBuilder targetVersionStorage, VersionCopyConfiguration config) {
        DescendantsIterator versionStorageIterator = new DescendantsIterator(sourceVersionStorage, 3);
        VersionCopier versionCopier = new VersionCopier(targetRoot, sourceVersionStorage, targetVersionStorage);
        while (versionStorageIterator.hasNext()) {
            NodeState versionHistoryBucket = (NodeState)versionStorageIterator.next();
            for (String versionHistory : versionHistoryBucket.getChildNodeNames()) {
                versionCopier.copyVersionHistory(versionHistory, config.getOrphanedMinDate());
            }
        }
    }

    public boolean copyVersionHistory(String versionableUuid, Calendar minDate) {
        String versionHistoryPath = VersionHistoryUtil.getRelativeVersionHistoryPath(versionableUuid);
        NodeState sourceVersionHistory = VersionHistoryUtil.getVersionHistoryNodeState(this.sourceVersionStorage, versionableUuid);
        Calendar lastModified = this.getVersionHistoryLastModified(sourceVersionHistory);
        if (sourceVersionHistory.exists() && (lastModified.after(minDate) || minDate.getTimeInMillis() == 0L)) {
            NodeStateCopier.builder().include(versionHistoryPath).merge("/jcr:system/jcr:versionStorage").copy(this.sourceVersionStorage, this.targetVersionStorage);
            return true;
        }
        return false;
    }

    private Calendar getVersionHistoryLastModified(NodeState versionHistory) {
        Calendar youngest = Calendar.getInstance();
        youngest.setTimeInMillis(0L);
        for (ChildNodeEntry childNodeEntry : versionHistory.getChildNodeEntries()) {
            Calendar created;
            NodeState version = childNodeEntry.getNodeState();
            if (!this.isVersion.apply(version) || !version.hasProperty("jcr:created") || !(created = ISO8601.parse(version.getProperty("jcr:created").getValue(Type.DATE))).after(youngest)) continue;
            youngest = created;
        }
        return youngest;
    }
}

