/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.upgrade.nodestate.report;

import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.upgrade.nodestate.report.PeriodicReporter;
import org.apache.jackrabbit.oak.upgrade.nodestate.report.ReportingNodeState;
import org.slf4j.Logger;

public class LoggingReporter
extends PeriodicReporter {
    private final Logger logger;
    private final String verb;

    public LoggingReporter(Logger logger, int nodeLogInterval, int propertyLogInterval) {
        this(logger, "Loading", nodeLogInterval, propertyLogInterval);
    }

    public LoggingReporter(Logger logger, String verb, int nodeLogInterval, int propertyLogInterval) {
        super(nodeLogInterval, propertyLogInterval);
        this.logger = logger;
        this.verb = verb;
    }

    @Override
    protected void reportPeriodicNode(long count, @Nonnull ReportingNodeState nodeState) {
        this.logger.info("{} node #{}: {}", this.verb, count, nodeState.getPath());
    }

    @Override
    protected void reportPeriodicProperty(long count, @Nonnull ReportingNodeState parent, @Nonnull String propertyName) {
        this.logger.info("{} properties #{}: {}", this.verb, count, PathUtils.concat(parent.getPath(), propertyName));
    }
}

