/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.upgrade.nodestate;

import com.google.common.base.Charsets;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.upgrade.nodestate.AbstractDecoratedNodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameFilteringNodeState
extends AbstractDecoratedNodeState {
    private static final Logger LOG = LoggerFactory.getLogger(NameFilteringNodeState.class);
    private static final int NODE_NAME_LIMIT = 150;
    private static final int SAFE_NODE_NAME_LENGTH = 37;

    public static NodeState wrap(NodeState delegate) {
        return new NameFilteringNodeState(delegate);
    }

    private NameFilteringNodeState(NodeState delegate) {
        super(delegate);
    }

    @Override
    protected boolean hideChild(@Nonnull String name, @Nonnull NodeState delegateChild) {
        if (NameFilteringNodeState.isNameTooLong(name)) {
            LOG.warn("Node name '{}' too long. Skipping child of {}", (Object)name, (Object)this);
            return true;
        }
        return super.hideChild(name, delegateChild);
    }

    @Override
    @Nonnull
    protected NodeState decorateChild(@Nonnull String name, @Nonnull NodeState delegateChild) {
        return NameFilteringNodeState.wrap(delegateChild);
    }

    @Override
    protected PropertyState decorateProperty(@Nonnull PropertyState delegatePropertyState) {
        return NameFilteringNodeState.fixChildOrderPropertyState(this, delegatePropertyState);
    }

    public static boolean isNameTooLong(@Nonnull String name) {
        return name.length() > 37 && name.getBytes(Charsets.UTF_8).length > 150;
    }
}

