/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.upgrade.nodestate;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.upgrade.nodestate.AbstractDecoratedNodeState;

public class FilteringNodeState
extends AbstractDecoratedNodeState {
    public static final Set<String> ALL = ImmutableSet.of("/");
    public static final Set<String> NONE = ImmutableSet.of();
    private final String path;
    private final Set<String> includedPaths;
    private final Set<String> excludedPaths;

    @Nonnull
    public static NodeState wrap(@Nonnull String path, @Nonnull NodeState delegate, @Nullable Set<String> includePaths, @Nullable Set<String> excludePaths) {
        Set<String> excludes;
        Set<String> includes = FilteringNodeState.defaultIfEmpty(includePaths, ALL);
        if (FilteringNodeState.hasHiddenDescendants(path, includes, excludes = FilteringNodeState.defaultIfEmpty(excludePaths, NONE))) {
            return new FilteringNodeState(path, delegate, includes, excludes);
        }
        return delegate;
    }

    private FilteringNodeState(@Nonnull String path, @Nonnull NodeState delegate, @Nonnull Set<String> includedPaths, @Nonnull Set<String> excludedPaths) {
        super(delegate);
        this.path = path;
        this.includedPaths = includedPaths;
        this.excludedPaths = excludedPaths;
    }

    @Override
    @Nonnull
    protected NodeState decorateChild(@Nonnull String name, @Nonnull NodeState child) {
        String childPath = PathUtils.concat(this.path, name);
        return FilteringNodeState.wrap(childPath, child, this.includedPaths, this.excludedPaths);
    }

    @Override
    protected boolean hideChild(@Nonnull String name, @Nonnull NodeState delegateChild) {
        return FilteringNodeState.isHidden(PathUtils.concat(this.path, name), this.includedPaths, this.excludedPaths);
    }

    @Override
    protected PropertyState decorateProperty(@Nonnull PropertyState propertyState) {
        return FilteringNodeState.fixChildOrderPropertyState(this, propertyState);
    }

    private static boolean isHidden(@Nonnull String path, @Nonnull Set<String> includes, @Nonnull Set<String> excludes) {
        return FilteringNodeState.isExcluded(path, excludes) || !FilteringNodeState.isIncluded(path, includes);
    }

    private static boolean hasHiddenDescendants(@Nonnull String path, @Nonnull Set<String> includePaths, @Nonnull Set<String> excludePaths) {
        return FilteringNodeState.isHidden(path, includePaths, excludePaths) || FilteringNodeState.isAncestorOfAnyPath(path, excludePaths) || FilteringNodeState.isAncestorOfAnyPath(path, includePaths);
    }

    private static boolean isIncluded(@Nonnull String path, @Nonnull Set<String> includePaths) {
        return FilteringNodeState.isAncestorOfAnyPath(path, includePaths) || includePaths.contains(path) || FilteringNodeState.isDescendantOfAnyPath(path, includePaths);
    }

    private static boolean isExcluded(@Nonnull String path, @Nonnull Set<String> excludePaths) {
        return excludePaths.contains(path) || FilteringNodeState.isDescendantOfAnyPath(path, excludePaths);
    }

    private static boolean isAncestorOfAnyPath(@Nonnull String ancestor, @Nonnull Set<String> paths) {
        for (String p : paths) {
            if (!PathUtils.isAncestor(ancestor, p)) continue;
            return true;
        }
        return false;
    }

    private static boolean isDescendantOfAnyPath(@Nonnull String descendant, @Nonnull Set<String> paths) {
        for (String p : paths) {
            if (!PathUtils.isAncestor(p, descendant)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    private static <T> Set<T> defaultIfEmpty(@Nullable Set<T> value, @Nonnull Set<T> defaultValue) {
        return !FilteringNodeState.isEmpty(value) ? value : defaultValue;
    }

    private static <T> boolean isEmpty(@Nullable Set<T> set) {
        return set == null || set.isEmpty();
    }
}

