/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.upgrade.cli.parser;

import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.oak.upgrade.cli.node.Jackrabbit2Factory;
import org.apache.jackrabbit.oak.upgrade.cli.node.JdbcFactory;
import org.apache.jackrabbit.oak.upgrade.cli.node.MongoFactory;
import org.apache.jackrabbit.oak.upgrade.cli.node.SegmentFactory;
import org.apache.jackrabbit.oak.upgrade.cli.node.SegmentTarFactory;
import org.apache.jackrabbit.oak.upgrade.cli.node.StoreFactory;
import org.apache.jackrabbit.oak.upgrade.cli.parser.MigrationOptions;
import org.apache.jackrabbit.oak.upgrade.cli.parser.StoreArguments;

public enum StoreType {
    JCR2_XML{

        @Override
        public boolean matches(String argument) {
            return Jackrabbit2Factory.isRepositoryXml(argument);
        }

        @Override
        public StoreFactory createFactory(String[] paths, StoreArguments.MigrationDirection direction, MigrationOptions migrationOptions) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isSupportLongNames() {
            return true;
        }
    }
    ,
    JCR2_DIR{

        @Override
        public boolean matches(String argument) {
            return Jackrabbit2Factory.isJcr2Repository(argument);
        }

        @Override
        public StoreFactory createFactory(String[] paths, StoreArguments.MigrationDirection direction, MigrationOptions migrationOptions) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isSupportLongNames() {
            return true;
        }
    }
    ,
    JCR2_DIR_XML{

        @Override
        public boolean matches(String argument) {
            return false;
        }

        @Override
        public StoreFactory createFactory(String[] paths, StoreArguments.MigrationDirection direction, MigrationOptions migrationOptions) {
            return new StoreFactory(new Jackrabbit2Factory(paths[0], paths[1]));
        }

        @Override
        public boolean isSupportLongNames() {
            return true;
        }
    }
    ,
    JDBC{

        @Override
        public boolean matches(String argument) {
            return argument.startsWith("jdbc:");
        }

        @Override
        public StoreFactory createFactory(String[] paths, StoreArguments.MigrationDirection direction, MigrationOptions migrationOptions) {
            String password;
            String username;
            if (direction == StoreArguments.MigrationDirection.SRC) {
                username = migrationOptions.getSrcUser();
                password = migrationOptions.getSrcPassword();
            } else {
                username = migrationOptions.getDstUser();
                password = migrationOptions.getDstPassword();
            }
            return new StoreFactory(new JdbcFactory(paths[0], migrationOptions.getCacheSizeInMB(), username, password));
        }

        @Override
        public boolean isSupportLongNames() {
            return false;
        }
    }
    ,
    MONGO{

        @Override
        public boolean matches(String argument) {
            return argument.startsWith("mongodb://");
        }

        @Override
        public StoreFactory createFactory(String[] paths, StoreArguments.MigrationDirection direction, MigrationOptions migrationOptions) {
            return new StoreFactory(new MongoFactory(paths[0], migrationOptions.getCacheSizeInMB()));
        }

        @Override
        public boolean isSupportLongNames() {
            return false;
        }
    }
    ,
    SEGMENT{

        @Override
        public boolean matches(String argument) {
            return argument.startsWith("segment-old:");
        }

        @Override
        public StoreFactory createFactory(String[] paths, StoreArguments.MigrationDirection direction, MigrationOptions migrationOptions) {
            String path = StringUtils.removeStart(paths[0], "segment-old:");
            return new StoreFactory(new SegmentFactory(path, migrationOptions.isDisableMmap()));
        }

        @Override
        public boolean isSupportLongNames() {
            return true;
        }
    }
    ,
    SEGMENT_TAR{

        @Override
        public boolean matches(String argument) {
            return true;
        }

        @Override
        public StoreFactory createFactory(String[] paths, StoreArguments.MigrationDirection direction, MigrationOptions migrationOptions) {
            return new StoreFactory(new SegmentTarFactory(paths[0], migrationOptions.isDisableMmap()));
        }

        @Override
        public boolean isSupportLongNames() {
            return true;
        }
    };


    public static StoreType getMatchingType(String argument) {
        for (StoreType t : StoreType.values()) {
            if (!t.matches(argument)) continue;
            return t;
        }
        return SEGMENT_TAR;
    }

    public abstract boolean matches(String var1);

    public abstract StoreFactory createFactory(String[] var1, StoreArguments.MigrationDirection var2, MigrationOptions var3);

    public abstract boolean isSupportLongNames();

    public boolean isSegment() {
        return this == SEGMENT || this == SEGMENT_TAR;
    }
}

