/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.upgrade.cli.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.jackrabbit.oak.plugins.segment.SegmentVersion;
import org.apache.jackrabbit.oak.upgrade.cli.node.StoreFactory;
import org.apache.jackrabbit.oak.upgrade.cli.parser.CliArgumentException;
import org.apache.jackrabbit.oak.upgrade.cli.parser.MigrationOptions;
import org.apache.jackrabbit.oak.upgrade.cli.parser.StoreType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreArguments {
    private static final String DEFAULT_CRX2_REPO = "crx-quickstart/repository";
    private static final String REPOSITORY_XML = "repository.xml";
    public static final String SEGMENT_OLD_PREFIX = "segment-old:";
    private static final Logger log = LoggerFactory.getLogger(StoreArguments.class);
    private final MigrationOptions options;
    private final StoreDescriptor src;
    private final StoreDescriptor dst;
    private Boolean srcHasExternalBlobRefs;

    public StoreArguments(MigrationOptions options, List<String> arguments) throws CliArgumentException {
        this.options = options;
        List<StoreDescriptor> descriptors = StoreArguments.createStoreDescriptors(arguments);
        this.src = descriptors.get(0);
        this.dst = descriptors.get(1);
    }

    public void logOptions() {
        log.info("Source: {}", (Object)this.src);
        log.info("Destination: {}", (Object)this.dst);
        if (this.dst.getType() == StoreType.SEGMENT) {
            StoreArguments.logSegmentVersion();
        }
    }

    public StoreFactory getSrcStore() {
        return this.src.getFactory(MigrationDirection.SRC, this.options);
    }

    public StoreFactory getDstStore() {
        return this.dst.getFactory(MigrationDirection.DST, this.options);
    }

    public StoreType getSrcType() {
        return this.src.getType();
    }

    public StoreType getDstType() {
        return this.dst.getType();
    }

    String getSrcDescriptor() {
        return this.src.toString();
    }

    String getDstDescriptor() {
        return this.dst.toString();
    }

    public boolean isInPlaceUpgrade() {
        if (this.src.getType() == StoreType.JCR2_DIR_XML && this.dst.getType() == StoreType.SEGMENT_TAR) {
            return this.src.getPath().equals(this.dst.getPath());
        }
        return false;
    }

    public String[] getSrcPaths() {
        return this.src.getPaths();
    }

    public boolean srcUsesEmbeddedDatastore() throws IOException {
        if (this.srcHasExternalBlobRefs == null) {
            this.srcHasExternalBlobRefs = this.src.getFactory(MigrationDirection.SRC, this.options).hasExternalBlobReferences();
        }
        return this.srcHasExternalBlobRefs == false;
    }

    private static List<StoreDescriptor> createStoreDescriptors(List<String> arguments) throws CliArgumentException {
        List<StoreDescriptor> descriptors = StoreArguments.mapToStoreDescriptors(arguments);
        StoreArguments.mergeCrx2Descriptors(descriptors);
        StoreArguments.addSegmentAsDestination(descriptors);
        StoreArguments.validateDescriptors(descriptors);
        return descriptors;
    }

    private static List<StoreDescriptor> mapToStoreDescriptors(List<String> arguments) throws CliArgumentException {
        ArrayList<StoreDescriptor> descriptors = new ArrayList<StoreDescriptor>();
        boolean jcr2Dir = false;
        boolean jcr2Xml = false;
        for (String argument : arguments) {
            StoreType type = StoreType.getMatchingType(argument);
            if (type == StoreType.JCR2_DIR) {
                if (jcr2Dir) {
                    type = StoreType.SEGMENT_TAR;
                }
                jcr2Dir = true;
            }
            if (type == StoreType.JCR2_DIR_XML) {
                if (jcr2Xml) {
                    throw new CliArgumentException("Too many repository.xml files passed as arguments", 1);
                }
                jcr2Xml = true;
            }
            descriptors.add(new StoreDescriptor(type, argument));
        }
        return descriptors;
    }

    private static void mergeCrx2Descriptors(List<StoreDescriptor> descriptors) {
        int crx2DirIndex = -1;
        int crx2XmlIndex = -1;
        for (int i = 0; i < descriptors.size(); ++i) {
            StoreType type = descriptors.get(i).getType();
            if (type == StoreType.JCR2_DIR) {
                crx2DirIndex = i;
                continue;
            }
            if (type != StoreType.JCR2_XML) continue;
            crx2XmlIndex = i;
        }
        if (crx2DirIndex > -1 || crx2XmlIndex > -1) {
            String repoXml;
            String repoDir;
            if (crx2DirIndex > -1) {
                repoDir = descriptors.get(crx2DirIndex).getPath();
                descriptors.set(crx2DirIndex, null);
            } else {
                repoDir = DEFAULT_CRX2_REPO;
            }
            if (crx2XmlIndex > -1) {
                repoXml = descriptors.get(crx2XmlIndex).getPath();
                descriptors.set(crx2XmlIndex, null);
            } else {
                repoXml = repoDir + "/" + REPOSITORY_XML;
            }
            descriptors.add(0, new StoreDescriptor(StoreType.JCR2_DIR_XML, repoDir, repoXml));
            Iterator<StoreDescriptor> it = descriptors.iterator();
            while (it.hasNext()) {
                if (it.next() != null) continue;
                it.remove();
            }
        }
    }

    private static void addSegmentAsDestination(List<StoreDescriptor> descriptors) {
        StoreType type;
        if (descriptors.size() == 1 && (type = descriptors.get(0).getType()) == StoreType.JCR2_DIR_XML) {
            String crx2Dir = descriptors.get(0).getPath();
            descriptors.add(new StoreDescriptor(StoreType.SEGMENT_TAR, crx2Dir));
            log.info("In place migration between JCR2 and SegmentNodeStore in {}", (Object)crx2Dir);
        }
    }

    private static void validateDescriptors(List<StoreDescriptor> descriptors) throws CliArgumentException {
        if (descriptors.size() < 2) {
            throw new CliArgumentException("Not enough node store arguments: " + descriptors.toString(), 1);
        }
        if (descriptors.size() > 2) {
            throw new CliArgumentException("Too much node store arguments: " + descriptors.toString(), 1);
        }
        if (descriptors.get(1).getType() == StoreType.JCR2_DIR_XML) {
            throw new CliArgumentException("Can't use CRX2 as a destination", 1);
        }
        StoreDescriptor src = descriptors.get(0);
        StoreDescriptor dst = descriptors.get(1);
        if (src.getType() == dst.getType() && src.getPath().equals(dst.getPath())) {
            throw new CliArgumentException("The source and the destination is the same repository.", 1);
        }
    }

    private static void logSegmentVersion() {
        SegmentVersion[] versions = SegmentVersion.values();
        SegmentVersion lastVersion = versions[versions.length - 1];
        log.info("Using Oak segment format {} - please make sure your version of AEM supports that format", (Object)lastVersion);
        if (lastVersion == SegmentVersion.V_11) {
            log.info("Requires Oak 1.0.12, 1.1.7 or later");
        }
    }

    private static class StoreDescriptor {
        private final String[] paths;
        private final StoreType type;

        public StoreDescriptor(StoreType type, String ... paths) {
            this.type = type;
            this.paths = paths;
        }

        public String[] getPaths() {
            return this.paths;
        }

        public String getPath() {
            return this.paths[0];
        }

        public StoreType getType() {
            return this.type;
        }

        public StoreFactory getFactory(MigrationDirection direction, MigrationOptions options) {
            return this.type.createFactory(this.paths, direction, options);
        }

        public String toString() {
            if (this.paths.length == 1) {
                return String.format("%s[%s]", new Object[]{this.type, this.getPath()});
            }
            return String.format("%s%s", new Object[]{this.type, Arrays.toString(this.getPaths())});
        }
    }

    static enum MigrationDirection {
        SRC,
        DST;

    }
}

