/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.upgrade.cli.parser;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.oak.upgrade.cli.parser.MigrationCliArguments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationOptions {
    private static final Logger log = LoggerFactory.getLogger(MigrationOptions.class);
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private final boolean copyBinaries;
    private final boolean disableMmap;
    private final int cacheSizeInMB;
    private final Calendar copyVersions;
    private final Calendar copyOrphanedVersions;
    private final String[] includePaths;
    private final String[] excludePaths;
    private final String[] mergePaths;
    private final boolean includeIndex;
    private final boolean failOnError;
    private final boolean earlyShutdown;
    private final boolean skipInitialization;
    private final boolean skipNameCheck;
    private final boolean ignoreMissingBinaries;
    private final String srcUser;
    private final String srcPassword;
    private final String dstUser;
    private final String dstPassword;
    private final String srcFbs;
    private final String srcFds;
    private final String srcS3Config;
    private final String srcS3;
    private final String dstFbs;
    private final String dstFds;
    private final String dstS3Config;
    private final String dstS3;

    public MigrationOptions(MigrationCliArguments args) {
        this.disableMmap = args.hasOption("disable-mmap");
        this.copyBinaries = args.hasOption("copy-binaries");
        this.cacheSizeInMB = args.hasOption("cache") ? args.getIntOption("cache") : 256;
        Calendar epoch = Calendar.getInstance();
        epoch.setTimeInMillis(0L);
        this.copyVersions = args.hasOption("copy-versions") ? MigrationOptions.parseVersionCopyArgument(args.getOption("copy-versions")) : epoch;
        this.copyOrphanedVersions = args.hasOption("copy-orphaned-versions") ? MigrationOptions.parseVersionCopyArgument(args.getOption("copy-orphaned-versions")) : epoch;
        this.includePaths = args.getOptionList("include-paths");
        this.excludePaths = args.getOptionList("exclude-paths");
        this.mergePaths = args.getOptionList("merge-paths");
        this.includeIndex = args.hasOption("include-index");
        this.failOnError = args.hasOption("fail-on-error");
        this.earlyShutdown = args.hasOption("early-shutdown");
        this.skipInitialization = args.hasOption("skip-init");
        this.skipNameCheck = args.hasOption("skip-name-check");
        this.ignoreMissingBinaries = args.hasOption("ignore-missing-binaries");
        this.srcUser = args.getOption("src-user");
        this.srcPassword = args.getOption("src-user");
        this.dstUser = args.getOption("user");
        this.dstPassword = args.getOption("password");
        this.srcFbs = args.getOption("src-fileblobstore");
        this.srcFds = args.getOption("src-datastore");
        this.srcS3 = args.getOption("src-s3datastore");
        this.srcS3Config = args.getOption("src-s3config");
        this.dstFbs = args.getOption("fileblobstore");
        this.dstFds = args.getOption("datastore");
        this.dstS3 = args.getOption("s3datastore");
        this.dstS3Config = args.getOption("s3config");
    }

    public boolean isCopyBinaries() {
        return this.copyBinaries;
    }

    public boolean isDisableMmap() {
        return this.disableMmap;
    }

    public int getCacheSizeInMB() {
        return this.cacheSizeInMB;
    }

    public Calendar getCopyVersions() {
        return this.copyVersions;
    }

    public Calendar getCopyOrphanedVersions() {
        return this.copyOrphanedVersions;
    }

    public String[] getIncludePaths() {
        return this.includePaths;
    }

    public String[] getExcludePaths() {
        return this.excludePaths;
    }

    public String[] getMergePaths() {
        return this.mergePaths;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public boolean isEarlyShutdown() {
        return this.earlyShutdown;
    }

    public boolean isSkipInitialization() {
        return this.skipInitialization;
    }

    public boolean isSkipNameCheck() {
        return this.skipNameCheck;
    }

    public boolean isIncludeIndex() {
        return this.includeIndex;
    }

    public boolean isIgnoreMissingBinaries() {
        return this.ignoreMissingBinaries;
    }

    public String getSrcUser() {
        return this.srcUser;
    }

    public String getSrcPassword() {
        return this.srcPassword;
    }

    public String getDstUser() {
        return this.dstUser;
    }

    public String getDstPassword() {
        return this.dstPassword;
    }

    public String getSrcFbs() {
        return this.srcFbs;
    }

    public String getSrcFds() {
        return this.srcFds;
    }

    public String getSrcS3Config() {
        return this.srcS3Config;
    }

    public String getSrcS3() {
        return this.srcS3;
    }

    public String getDstFbs() {
        return this.dstFbs;
    }

    public String getDstFds() {
        return this.dstFds;
    }

    public String getDstS3Config() {
        return this.dstS3Config;
    }

    public String getDstS3() {
        return this.dstS3;
    }

    public boolean isSrcFds() {
        return StringUtils.isNotBlank(this.srcFds);
    }

    public boolean isSrcFbs() {
        return StringUtils.isNotBlank(this.srcFbs);
    }

    public boolean isSrcS3() {
        return StringUtils.isNotBlank(this.srcS3) && StringUtils.isNotBlank(this.srcS3Config);
    }

    public boolean isDstFds() {
        return StringUtils.isNotBlank(this.dstFds);
    }

    public boolean isDstFbs() {
        return StringUtils.isNotBlank(this.dstFbs);
    }

    public boolean isDstS3() {
        return StringUtils.isNotBlank(this.dstS3) && StringUtils.isNotBlank(this.dstS3Config);
    }

    public boolean isSrcBlobStoreDefined() {
        return this.isSrcFbs() || this.isSrcFds() || this.isSrcS3();
    }

    public boolean isDstBlobStoreDefined() {
        return this.isDstFbs() || this.isDstFds() || this.isDstS3();
    }

    public void logOptions() {
        if (this.disableMmap) {
            log.info("Disabling memory mapped file access for Segment Store");
        }
        if (this.copyVersions == null) {
            log.info("copyVersions parameter set to false");
        } else {
            log.info("copyVersions parameter set to {}", (Object)DATE_FORMAT.format(this.copyVersions.getTime()));
        }
        if (this.copyOrphanedVersions == null) {
            log.info("copyOrphanedVersions parameter set to false");
        } else {
            log.info("copyOrphanedVersions parameter set to {}", (Object)DATE_FORMAT.format(this.copyOrphanedVersions.getTime()));
        }
        if (this.includePaths != null) {
            log.info("paths to include: {}", (Object)this.includePaths);
        }
        if (this.excludePaths != null) {
            log.info("paths to exclude: {}", (Object)this.excludePaths);
        }
        if (this.failOnError) {
            log.info("Unreadable nodes will cause failure of the entire transaction");
        }
        if (this.earlyShutdown) {
            log.info("Source repository would be shutdown post copying of nodes");
        }
        if (this.skipInitialization) {
            log.info("The repository initialization will be skipped");
        }
        if (this.skipNameCheck) {
            log.info("Test for long-named nodes will be disabled");
        }
        if (this.includeIndex) {
            log.info("Index data for the paths {} will be copied", (Object)this.includePaths);
        }
        if (this.ignoreMissingBinaries) {
            log.info("Missing binaries won't break the migration");
        }
        log.info("Cache size: {} MB", (Object)this.cacheSizeInMB);
    }

    private static Calendar parseVersionCopyArgument(String string) {
        Calendar calendar;
        if (Boolean.parseBoolean(string)) {
            calendar = Calendar.getInstance();
            calendar.setTimeInMillis(0L);
        } else if (string != null && string.matches("^\\d{4}-\\d{2}-\\d{2}$")) {
            calendar = Calendar.getInstance();
            try {
                calendar.setTime(DATE_FORMAT.parse(string));
            }
            catch (ParseException e) {
                return null;
            }
        } else {
            calendar = null;
        }
        return calendar;
    }
}

