/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.upgrade.cli.parser;

import java.util.ArrayList;
import java.util.List;
import joptsimple.OptionSet;
import org.apache.jackrabbit.oak.upgrade.cli.parser.CliArgumentException;

public final class MigrationCliArguments {
    private final OptionSet options;
    private final List<String> arguments;

    public MigrationCliArguments(OptionSet options) throws CliArgumentException {
        this.options = options;
        this.arguments = this.getNonOptionArguments();
    }

    private List<String> getNonOptionArguments() {
        ArrayList<String> args = new ArrayList<String>();
        for (Object o : this.options.nonOptionArguments()) {
            args.add(o.toString());
        }
        return args;
    }

    public boolean hasOption(String optionName) {
        return this.options.has(optionName);
    }

    public String getOption(String optionName) {
        return (String)this.options.valueOf(optionName);
    }

    public int getIntOption(String optionName) {
        return (Integer)this.options.valueOf(optionName);
    }

    public String[] getOptionList(String optionName) {
        String option = this.getOption(optionName);
        if (option == null) {
            return null;
        }
        return option.split(",");
    }

    public List<String> getArguments() {
        return this.arguments;
    }
}

