/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.upgrade.cli.parser;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.upgrade.cli.blob.BlobStoreFactory;
import org.apache.jackrabbit.oak.upgrade.cli.blob.ConstantBlobStoreFactory;
import org.apache.jackrabbit.oak.upgrade.cli.blob.DummyBlobStoreFactory;
import org.apache.jackrabbit.oak.upgrade.cli.blob.FileBlobStoreFactory;
import org.apache.jackrabbit.oak.upgrade.cli.blob.FileDataStoreFactory;
import org.apache.jackrabbit.oak.upgrade.cli.blob.MissingBlobStoreFactory;
import org.apache.jackrabbit.oak.upgrade.cli.blob.S3DataStoreFactory;
import org.apache.jackrabbit.oak.upgrade.cli.parser.CliArgumentException;
import org.apache.jackrabbit.oak.upgrade.cli.parser.MigrationOptions;
import org.apache.jackrabbit.oak.upgrade.cli.parser.StoreArguments;
import org.apache.jackrabbit.oak.upgrade.cli.parser.StoreType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatastoreArguments {
    private static final Logger log = LoggerFactory.getLogger(DatastoreArguments.class);
    private final BlobStoreFactory definedSrcBlob;
    private final BlobStoreFactory definedDstBlob;
    private final StoreArguments storeArguments;
    private final BlobMigrationCase blobMigrationCase;
    private final MigrationOptions options;
    private final boolean srcEmbedded;

    public DatastoreArguments(MigrationOptions options, StoreArguments storeArguments, boolean srcEmbedded) throws CliArgumentException {
        this.storeArguments = storeArguments;
        this.options = options;
        this.srcEmbedded = srcEmbedded;
        try {
            this.blobMigrationCase = this.discoverBlobMigrationCase();
        }
        catch (IOException e) {
            log.error("Can't figure out the right blob migration path", e);
            throw new CliArgumentException(1);
        }
        if (this.blobMigrationCase == BlobMigrationCase.UNSUPPORTED) {
            throw new CliArgumentException("This combination of data- and node-stores is not supported", 1);
        }
        try {
            this.definedSrcBlob = options.isSrcBlobStoreDefined() ? this.getDefinedSrcBlobStore() : null;
            this.definedDstBlob = options.isDstBlobStoreDefined() ? this.getDefinedDstBlobStore() : null;
        }
        catch (IOException e) {
            log.error("Can't read the blob configuration", e);
            throw new CliArgumentException(1);
        }
        log.info(this.blobMigrationCase.getDescription(this));
    }

    public BlobStoreFactory getSrcBlobStore() throws IOException {
        BlobStoreFactory result = this.options.isSrcBlobStoreDefined() ? this.definedSrcBlob : (this.blobMigrationCase == BlobMigrationCase.COPY_REFERENCES ? new MissingBlobStoreFactory() : new DummyBlobStoreFactory());
        log.info("Source blob store: {}", (Object)result);
        return result;
    }

    public BlobStoreFactory getDstBlobStore(BlobStore srcBlobStore) throws IOException {
        BlobStoreFactory result = this.options.isDstBlobStoreDefined() ? this.definedDstBlob : (this.blobMigrationCase == BlobMigrationCase.COPY_REFERENCES && (this.options.isSrcBlobStoreDefined() || this.storeArguments.getSrcType() == StoreType.JCR2_DIR_XML) ? new ConstantBlobStoreFactory(srcBlobStore) : (this.blobMigrationCase == BlobMigrationCase.COPY_REFERENCES ? new MissingBlobStoreFactory() : new DummyBlobStoreFactory()));
        log.info("Destination blob store: {}", (Object)result);
        return result;
    }

    private BlobStoreFactory getDefinedSrcBlobStore() throws IOException {
        boolean ignoreMissingBinaries = this.options.isIgnoreMissingBinaries();
        if (this.options.isSrcFbs()) {
            return new FileBlobStoreFactory(this.options.getSrcFbs());
        }
        if (this.options.isSrcS3()) {
            return new S3DataStoreFactory(this.options.getSrcS3Config(), this.options.getSrcS3(), ignoreMissingBinaries);
        }
        if (this.options.isSrcFds()) {
            return new FileDataStoreFactory(this.options.getSrcFds(), ignoreMissingBinaries);
        }
        return null;
    }

    private BlobStoreFactory getDefinedDstBlobStore() throws IOException {
        if (this.options.isDstFbs()) {
            return new FileBlobStoreFactory(this.options.getDstFbs());
        }
        if (this.options.isDstS3()) {
            return new S3DataStoreFactory(this.options.getDstS3Config(), this.options.getDstS3(), false);
        }
        if (this.options.isDstFds()) {
            return new FileDataStoreFactory(this.options.getDstFds(), false);
        }
        return null;
    }

    public BlobMigrationCase getBlobMigrationCase() {
        return this.blobMigrationCase;
    }

    private BlobMigrationCase discoverBlobMigrationCase() throws IOException {
        boolean srcDefined = this.options.isSrcBlobStoreDefined() || this.storeArguments.getSrcType() == StoreType.JCR2_DIR_XML;
        boolean dstDefined = this.options.isDstBlobStoreDefined();
        boolean copyBinaries = this.options.isCopyBinaries();
        boolean srcSegment = this.storeArguments.getSrcType().isSegment();
        boolean dstSegment = this.storeArguments.getDstType().isSegment();
        if (!(srcDefined || dstDefined || this.srcEmbedded || copyBinaries)) {
            if (srcSegment && !dstSegment) {
                return BlobMigrationCase.UNSUPPORTED;
            }
            return BlobMigrationCase.COPY_REFERENCES;
        }
        if (!srcDefined && !dstDefined && !this.srcEmbedded && copyBinaries) {
            return BlobMigrationCase.UNSUPPORTED;
        }
        if (!srcDefined && !this.srcEmbedded && dstDefined) {
            return BlobMigrationCase.UNSUPPORTED;
        }
        if (!srcDefined && this.srcEmbedded && !dstDefined) {
            return BlobMigrationCase.EMBEDDED_TO_EMBEDDED;
        }
        if (!srcDefined && this.srcEmbedded && dstDefined) {
            return BlobMigrationCase.EMBEDDED_TO_EXTERNAL;
        }
        if (srcDefined && !dstDefined && !copyBinaries) {
            return BlobMigrationCase.COPY_REFERENCES;
        }
        if (srcDefined && !dstDefined && copyBinaries) {
            return BlobMigrationCase.EXTERNAL_TO_EMBEDDED;
        }
        if (srcDefined && dstDefined) {
            return BlobMigrationCase.EXTERNAL_TO_EXTERNAL;
        }
        return BlobMigrationCase.UNSUPPORTED;
    }

    public static enum BlobMigrationCase {
        COPY_REFERENCES("Only blob references will be copied"),
        EMBEDDED_TO_EMBEDDED("Blobs embedded in ${srcnode} will be embedded in ${dstnode}"),
        EMBEDDED_TO_EXTERNAL("Blobs embedded in ${srcnode} will be copied to ${dstblob}"),
        EXTERNAL_TO_EMBEDDED("Blobs stored in ${srcblob} will be embedded in ${dstnode}"),
        EXTERNAL_TO_EXTERNAL("Blobs stored in ${srcblob} will be copied to ${dstblob}"),
        UNSUPPORTED("Unsupported case");

        private final String description;

        private BlobMigrationCase(String description) {
            this.description = description;
        }

        private String getDescription(DatastoreArguments datastoreArguments) {
            HashMap<String, String> map = Maps.newHashMap();
            map.put("srcnode", datastoreArguments.storeArguments.getSrcDescriptor());
            map.put("dstnode", datastoreArguments.storeArguments.getDstDescriptor());
            if (datastoreArguments.storeArguments.getSrcType() == StoreType.JCR2_DIR_XML) {
                map.put("srcblob", "CRX2 datastore");
            } else {
                map.put("srcblob", datastoreArguments.definedSrcBlob == null ? "?" : datastoreArguments.definedSrcBlob.toString());
            }
            map.put("dstblob", datastoreArguments.definedDstBlob == null ? "?" : datastoreArguments.definedDstBlob.toString());
            StrSubstitutor subst = new StrSubstitutor(map);
            return subst.replace(this.description);
        }
    }
}

