/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.upgrade.cli.node;

import com.google.common.io.Closer;
import java.io.IOException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.upgrade.cli.node.Jackrabbit2Factory;
import org.apache.jackrabbit.oak.upgrade.cli.node.NodeStoreFactory;

public class StoreFactory {
    private final Jackrabbit2Factory jcr2Factory;
    private final NodeStoreFactory nodeStoreFactory;

    public StoreFactory(Jackrabbit2Factory crx2Factory) {
        this.jcr2Factory = crx2Factory;
        this.nodeStoreFactory = null;
    }

    public StoreFactory(NodeStoreFactory nodeStoreFactory) {
        this.jcr2Factory = null;
        this.nodeStoreFactory = nodeStoreFactory;
    }

    public RepositoryContext create(Closer closer) throws IOException, RepositoryException {
        if (this.jcr2Factory == null) {
            throw new UnsupportedOperationException();
        }
        return this.jcr2Factory.create(closer);
    }

    public NodeStore create(BlobStore blobStore, Closer closer) throws IOException {
        if (this.nodeStoreFactory == null) {
            throw new UnsupportedOperationException();
        }
        return this.nodeStoreFactory.create(blobStore, closer);
    }

    public boolean isJcr2() {
        return this.jcr2Factory != null;
    }

    public boolean hasExternalBlobReferences() throws IOException {
        if (this.isJcr2()) {
            return true;
        }
        return this.nodeStoreFactory.hasExternalBlobReferences();
    }
}

