/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.upgrade.cli.node;

import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.plugins.blob.ReferenceCollector;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeBuilder;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeStore;
import org.apache.jackrabbit.oak.plugins.segment.file.FileStore;
import org.apache.jackrabbit.oak.plugins.segment.file.InvalidFileStoreVersionException;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.upgrade.cli.node.NodeStoreFactory;
import org.apache.jackrabbit.oak.upgrade.cli.node.TarNodeStore;

public class SegmentFactory
implements NodeStoreFactory {
    private final File dir;
    private final boolean disableMmap;

    public SegmentFactory(String directory, boolean disableMmap) {
        this.dir = new File(directory);
        this.disableMmap = disableMmap;
        this.createDirectoryIfMissing(this.dir);
        if (!this.dir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + this.dir.getPath());
        }
    }

    private void createDirectoryIfMissing(File directory) {
        if (!directory.exists()) {
            directory.mkdirs();
        }
    }

    @Override
    public NodeStore create(BlobStore blobStore, Closer closer) throws IOException {
        FileStore fs;
        FileStore.Builder builder = FileStore.builder(new File(this.dir, "segmentstore"));
        if (blobStore != null) {
            builder.withBlobStore(blobStore);
        }
        builder.withMaxFileSize(256);
        if (this.disableMmap) {
            builder.withMemoryMapping(false);
        } else {
            builder.withDefaultMemoryMapping();
        }
        try {
            fs = builder.build();
        }
        catch (InvalidFileStoreVersionException e) {
            throw new IllegalStateException(e);
        }
        closer.register(SegmentFactory.asCloseable(fs));
        return new TarNodeStore(SegmentNodeStore.builder(fs).build(), new TarNodeStore.SuperRootProvider(){

            @Override
            public void setSuperRoot(NodeBuilder builder) {
                Preconditions.checkArgument(builder instanceof SegmentNodeBuilder);
                SegmentNodeBuilder segmentBuilder = (SegmentNodeBuilder)builder;
                SegmentNodeState lastRoot = (SegmentNodeState)this.getSuperRoot();
                if (!lastRoot.getRecordId().equals(((SegmentNodeState)segmentBuilder.getBaseState()).getRecordId())) {
                    throw new IllegalArgumentException("The new head is out of date");
                }
                fs.setHead(lastRoot, ((SegmentNodeBuilder)builder).getNodeState());
            }

            @Override
            public NodeState getSuperRoot() {
                return fs.getHead();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasExternalBlobReferences() throws IOException {
        FileStore fs;
        FileStore.Builder builder = FileStore.builder(new File(this.dir, "segmentstore"));
        builder.withMaxFileSize(256);
        if (this.disableMmap) {
            builder.withMemoryMapping(false);
        } else {
            builder.withDefaultMemoryMapping();
        }
        try {
            fs = builder.build();
        }
        catch (InvalidFileStoreVersionException e) {
            throw new IOException(e);
        }
        try {
            fs.getTracker().collectBlobReferences(new ReferenceCollector(){

                @Override
                public void addReference(String reference, @Nullable String nodeId) {
                    throw new ExternalBlobFound();
                }
            });
            boolean e = false;
            return e;
        }
        catch (ExternalBlobFound e) {
            boolean bl = true;
            return bl;
        }
        finally {
            fs.close();
        }
    }

    public File getRepositoryDir() {
        return this.dir;
    }

    private static Closeable asCloseable(final FileStore fs) {
        return new Closeable(){

            @Override
            public void close() throws IOException {
                fs.close();
            }
        };
    }

    public String toString() {
        return String.format("SegmentNodeStore[%s]", this.dir);
    }

    private static class ExternalBlobFound
    extends RuntimeException {
        private ExternalBlobFound() {
        }
    }
}

