/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.upgrade.cli.node;

import com.google.common.io.Closer;
import com.mongodb.DB;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import java.io.Closeable;
import java.io.IOException;
import java.net.UnknownHostException;
import org.apache.jackrabbit.oak.plugins.document.DocumentMK;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoBlobStore;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.upgrade.cli.node.NodeStoreFactory;

public class MongoFactory
implements NodeStoreFactory {
    private static final long MB = 0x100000L;
    private final MongoClientURI uri;
    private final int cacheSize;

    public MongoFactory(String repoDesc, int cacheSize) {
        this.uri = new MongoClientURI(repoDesc);
        this.cacheSize = cacheSize;
    }

    @Override
    public NodeStore create(BlobStore blobStore, Closer closer) throws UnknownHostException {
        DocumentMK.Builder builder = MongoFactory.getBuilder(this.cacheSize);
        builder.setMongoDB(this.getDB(closer));
        if (blobStore != null) {
            builder.setBlobStore(blobStore);
        }
        DocumentNodeStore documentNodeStore = builder.getNodeStore();
        closer.register(MongoFactory.asCloseable(documentNodeStore));
        return documentNodeStore;
    }

    private DB getDB(Closer closer) throws UnknownHostException {
        String db = this.uri.getDatabase() == null ? "aem-author" : this.uri.getDatabase();
        MongoClient client = new MongoClient(this.uri);
        closer.register(MongoFactory.asCloseable(client));
        return client.getDB(db);
    }

    @Override
    public boolean hasExternalBlobReferences() throws IOException {
        try (Closer closer = Closer.create();){
            MongoBlobStore mongoBlobStore = new MongoBlobStore(this.getDB(closer));
            boolean bl = !mongoBlobStore.getAllChunkIds(0L).hasNext();
            return bl;
        }
    }

    static Closeable asCloseable(final DocumentNodeStore documentNodeStore) {
        return new Closeable(){

            @Override
            public void close() throws IOException {
                documentNodeStore.dispose();
            }
        };
    }

    private static Closeable asCloseable(final MongoClient client) {
        return new Closeable(){

            @Override
            public void close() throws IOException {
                client.close();
            }
        };
    }

    static DocumentMK.Builder getBuilder(int cacheSize) {
        boolean fastMigration = !Boolean.getBoolean("mongomk.disableFastMigration");
        DocumentMK.Builder builder = new DocumentMK.Builder();
        builder.memoryCacheSize((long)cacheSize * 0x100000L);
        if (fastMigration) {
            builder.disableBranches();
        }
        return builder;
    }

    public String toString() {
        return String.format("DocumentNodeStore[%s]", this.uri.toString());
    }
}

