/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.upgrade.cli.node;

import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import javax.sql.DataSource;
import org.apache.jackrabbit.oak.plugins.document.DocumentMK;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBBlobStore;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBDataSourceFactory;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.upgrade.cli.node.MongoFactory;
import org.apache.jackrabbit.oak.upgrade.cli.node.NodeStoreFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcFactory
implements NodeStoreFactory {
    private static final Logger log = LoggerFactory.getLogger(JdbcFactory.class);
    private final String jdbcUri;
    private final int cacheSize;
    private final String user;
    private final String password;

    public JdbcFactory(String jdbcUri, int cacheSize, String user, String password) {
        this.jdbcUri = jdbcUri;
        this.cacheSize = cacheSize;
        if (user == null || password == null) {
            throw new IllegalArgumentException("RBD requires username and password parameters.");
        }
        this.user = user;
        this.password = password;
    }

    @Override
    public NodeStore create(BlobStore blobStore, Closer closer) {
        DocumentMK.Builder builder = MongoFactory.getBuilder(this.cacheSize);
        if (blobStore != null) {
            builder.setBlobStore(blobStore);
        }
        builder.setRDBConnection(this.getDataSource(closer));
        log.info("Initialized DocumentNodeStore on RDB with Cache size : {} MB, Fast migration : {}", (Object)this.cacheSize, (Object)builder.isDisableBranches());
        DocumentNodeStore documentNodeStore = builder.getNodeStore();
        closer.register(MongoFactory.asCloseable(documentNodeStore));
        return documentNodeStore;
    }

    private DataSource getDataSource(Closer closer) {
        DataSource ds = RDBDataSourceFactory.forJdbcUrl(this.jdbcUri, this.user, this.password);
        if (ds instanceof Closeable) {
            closer.register((Closeable)((Object)ds));
        }
        return ds;
    }

    @Override
    public boolean hasExternalBlobReferences() throws IOException {
        try (Closer closer = Closer.create();){
            DataSource ds = this.getDataSource(closer);
            RDBBlobStore blobStore = new RDBBlobStore(ds);
            boolean bl = !blobStore.getAllChunkIds(0L).hasNext();
            return bl;
        }
    }

    public String toString() {
        return String.format("DocumentNodeStore[%s]", this.jdbcUri);
    }
}

