/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.upgrade.cli.node;

import com.google.common.io.Closer;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import javax.jcr.RepositoryException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.config.RepositoryConfig;

public class Jackrabbit2Factory {
    private final File repositoryDir;
    private final File repositoryFile;

    public Jackrabbit2Factory(String repositoryDir, String repositoryFile) {
        if (!Jackrabbit2Factory.isJcr2Repository(repositoryDir)) {
            throw new IllegalArgumentException("Repository directory not found: " + repositoryDir);
        }
        this.repositoryDir = new File(repositoryDir);
        this.repositoryFile = new File(repositoryFile);
        if (!Jackrabbit2Factory.isRepositoryXml(repositoryFile)) {
            throw new IllegalArgumentException("Repository configuration not found: " + repositoryFile);
        }
    }

    public RepositoryContext create(Closer closer) throws RepositoryException {
        RepositoryContext source = RepositoryContext.create(RepositoryConfig.create(this.repositoryFile, this.repositoryDir));
        closer.register(Jackrabbit2Factory.asCloseable(source));
        return source;
    }

    public File getRepositoryDir() {
        return this.repositoryDir;
    }

    private static Closeable asCloseable(final RepositoryContext context) {
        return new Closeable(){

            @Override
            public void close() throws IOException {
                context.getRepository().shutdown();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean isRepositoryXml(String path) {
        File file = new File(path);
        if (file.isFile()) {
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new FileReader(file));
                while ((line = reader.readLine()) != null) {
                    if (!StringUtils.containsIgnoreCase(line, "<Repository>")) continue;
                    boolean bl = true;
                    IOUtils.closeQuietly(reader);
                    return bl;
                }
                IOUtils.closeQuietly(reader);
            }
            catch (FileNotFoundException e) {
                boolean bl = false;
                return bl;
            }
            catch (IOException e2) {
                boolean bl = false;
                return bl;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeQuietly(reader);
            }
        }
        return false;
    }

    public static boolean isJcr2Repository(String directory) {
        File dir = new File(directory);
        if (!dir.isDirectory()) {
            return false;
        }
        File workspaces = new File(dir, "workspaces");
        return workspaces.isDirectory();
    }

    public String toString() {
        return String.format("JCR2[%s, %s]", this.repositoryDir, this.repositoryFile);
    }
}

