/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.upgrade.cli.blob;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.oak.plugins.blob.datastore.DataStoreBlobStore;
import org.apache.jackrabbit.oak.plugins.blob.datastore.InMemoryDataRecord;
import org.apache.jackrabbit.oak.spi.blob.stats.StatsCollectingStreams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SafeDataStoreBlobStore
extends DataStoreBlobStore {
    private static final Logger log = LoggerFactory.getLogger(SafeDataStoreBlobStore.class);

    public SafeDataStoreBlobStore(DataStore delegate) {
        super(delegate);
    }

    @Override
    public String getReference(@Nonnull String encodedBlobId) {
        Preconditions.checkNotNull(encodedBlobId);
        String blobId = this.extractBlobId(encodedBlobId);
        if (InMemoryDataRecord.isInstance(blobId)) {
            return null;
        }
        try {
            DataRecord record = this.delegate.getRecordIfStored(new DataIdentifier(blobId));
            if (record != null) {
                return record.getReference();
            }
            log.debug("No blob found for id [{}]", (Object)blobId);
        }
        catch (DataStoreException e) {
            log.warn("Unable to access the blobId for  [{}]", (Object)blobId, (Object)e);
        }
        return null;
    }

    @Override
    protected InputStream getStream(String blobId) throws IOException {
        try {
            DataRecord record = this.getDataRecord(blobId);
            if (record == null) {
                log.warn("No blob found for id [{}]", (Object)blobId);
                return new ByteArrayInputStream(new byte[0]);
            }
            InputStream in = this.getDataRecord(blobId).getStream();
            if (!(in instanceof BufferedInputStream)) {
                in = new BufferedInputStream(in);
            }
            return StatsCollectingStreams.wrap(this.stats, blobId, in);
        }
        catch (DataStoreException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected DataRecord getDataRecord(String blobId) throws DataStoreException {
        DataRecord id = InMemoryDataRecord.isInstance(blobId) ? InMemoryDataRecord.getInstance(blobId) : this.delegate.getRecordIfStored(new DataIdentifier(blobId));
        return id;
    }
}

