/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.upgrade.cli.blob;

import com.google.common.io.Closer;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.aws.ext.ds.S3DataStore;
import org.apache.jackrabbit.core.data.CachingDataStore;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.oak.plugins.blob.datastore.DataStoreBlobStore;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.upgrade.cli.blob.BlobStoreFactory;
import org.apache.jackrabbit.oak.upgrade.cli.blob.SafeDataStoreBlobStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3DataStoreFactory
implements BlobStoreFactory {
    private static final Logger log = LoggerFactory.getLogger(S3DataStoreFactory.class);
    private static final Pattern STRIP_VALUE_PATTERN = Pattern.compile("^[TILFDXSCB]?\"(.*)\"\\W*$");
    private final Properties props = new Properties();
    private final String directory;
    private final File tempHomeDir;
    private final boolean ignoreMissingBlobs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S3DataStoreFactory(String configuration, String directory, boolean ignoreMissingBlobs) throws IOException {
        FileReader reader = new FileReader(new File(configuration));
        try {
            this.props.load(reader);
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
        for (Object key : new HashSet<Object>(this.props.keySet())) {
            String value = this.props.getProperty((String)key);
            this.props.put(key, S3DataStoreFactory.stripValue(value));
        }
        this.directory = directory;
        this.tempHomeDir = Files.createTempDir();
        this.ignoreMissingBlobs = ignoreMissingBlobs;
    }

    @Override
    public BlobStore create(Closer closer) throws IOException {
        S3DataStore delegate = new S3DataStore();
        delegate.setProperties(this.props);
        delegate.setPath(this.directory);
        try {
            delegate.init(this.tempHomeDir.getPath());
        }
        catch (RepositoryException e) {
            throw new IOException(e);
        }
        closer.register(S3DataStoreFactory.asCloseable(delegate, this.tempHomeDir));
        if (this.ignoreMissingBlobs) {
            return new SafeDataStoreBlobStore(delegate);
        }
        return new DataStoreBlobStore(delegate);
    }

    private static Closeable asCloseable(final CachingDataStore store, final File tempHomeDir) {
        return new Closeable(){

            @Override
            public void close() throws IOException {
                try {
                    while (!store.getPendingUploads().isEmpty()) {
                        log.info("Waiting for following uploads to finish: " + store.getPendingUploads());
                        Thread.sleep(1000L);
                    }
                    store.close();
                    FileUtils.deleteDirectory(tempHomeDir);
                }
                catch (DataStoreException e) {
                    throw new IOException(e);
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
            }
        };
    }

    static String stripValue(String value) {
        Matcher matcher = STRIP_VALUE_PATTERN.matcher(value);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return value;
    }

    public String toString() {
        return String.format("S3DataStore[%s]", this.directory);
    }
}

