/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.upgrade.cli.blob;

import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import org.apache.jackrabbit.core.data.FileDataStore;
import org.apache.jackrabbit.oak.plugins.blob.datastore.DataStoreBlobStore;
import org.apache.jackrabbit.oak.plugins.blob.datastore.OakFileDataStore;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.upgrade.cli.blob.BlobStoreFactory;
import org.apache.jackrabbit.oak.upgrade.cli.blob.SafeDataStoreBlobStore;

public class FileDataStoreFactory
implements BlobStoreFactory {
    private final String directory;
    private final boolean ignoreMissingBlobs;

    public FileDataStoreFactory(String directory, boolean ignoreMissingBlobs) {
        this.directory = directory;
        this.ignoreMissingBlobs = ignoreMissingBlobs;
    }

    @Override
    public BlobStore create(Closer closer) {
        OakFileDataStore delegate = new OakFileDataStore();
        delegate.setPath(this.directory);
        delegate.init(null);
        closer.register(FileDataStoreFactory.asCloseable(delegate));
        if (this.ignoreMissingBlobs) {
            return new SafeDataStoreBlobStore(delegate);
        }
        return new DataStoreBlobStore(delegate);
    }

    private static Closeable asCloseable(final FileDataStore store) {
        return new Closeable(){

            @Override
            public void close() throws IOException {
                store.close();
            }
        };
    }

    public String toString() {
        return String.format("FileDataStore[%s]", this.directory);
    }
}

