/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.upgrade.cli;

import com.google.common.collect.Lists;
import com.google.common.io.Closer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ServiceLoader;
import javax.jcr.RepositoryException;
import joptsimple.OptionSet;
import org.apache.jackrabbit.oak.spi.lifecycle.CompositeInitializer;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.upgrade.cli.CliUtils;
import org.apache.jackrabbit.oak.upgrade.cli.MigrationFactory;
import org.apache.jackrabbit.oak.upgrade.cli.parser.CliArgumentException;
import org.apache.jackrabbit.oak.upgrade.cli.parser.DatastoreArguments;
import org.apache.jackrabbit.oak.upgrade.cli.parser.MigrationCliArguments;
import org.apache.jackrabbit.oak.upgrade.cli.parser.MigrationOptions;
import org.apache.jackrabbit.oak.upgrade.cli.parser.OptionParserFactory;
import org.apache.jackrabbit.oak.upgrade.cli.parser.StoreArguments;

public class OakUpgrade {
    public static void main(String ... args) throws IOException {
        OptionSet options = OptionParserFactory.create().parse(args);
        try {
            MigrationCliArguments cliArguments = new MigrationCliArguments(options);
            if (cliArguments.hasOption("help") || cliArguments.getArguments().isEmpty()) {
                CliUtils.displayUsage();
                return;
            }
            OakUpgrade.migrate(cliArguments);
        }
        catch (CliArgumentException e) {
            if (e.getMessage() != null) {
                System.err.println(e.getMessage());
            }
            System.exit(e.getExitCode());
        }
    }

    public static void migrate(MigrationCliArguments argumentParser) throws IOException, CliArgumentException {
        MigrationOptions options = new MigrationOptions(argumentParser);
        options.logOptions();
        StoreArguments stores = new StoreArguments(options, argumentParser.getArguments());
        stores.logOptions();
        boolean srcEmbedded = stores.srcUsesEmbeddedDatastore();
        DatastoreArguments datastores = new DatastoreArguments(options, stores, srcEmbedded);
        OakUpgrade.migrate(options, stores, datastores);
    }

    public static void migrate(MigrationOptions options, StoreArguments stores, DatastoreArguments datastores) throws IOException, CliArgumentException {
        Closer closer = Closer.create();
        CliUtils.handleSigInt(closer);
        MigrationFactory factory = new MigrationFactory(options, stores, datastores, closer);
        try {
            if (stores.getSrcStore().isJcr2()) {
                OakUpgrade.upgrade(factory);
            } else {
                OakUpgrade.sidegrade(factory);
            }
        }
        catch (Throwable t) {
            throw closer.rethrow(t);
        }
        finally {
            closer.close();
        }
    }

    private static void upgrade(MigrationFactory migrationFactory) throws IOException, RepositoryException, CliArgumentException {
        migrationFactory.createUpgrade().copy(OakUpgrade.createCompositeInitializer());
    }

    private static void sidegrade(MigrationFactory migrationFactory) throws IOException, RepositoryException, CliArgumentException {
        migrationFactory.createSidegrade().copy();
    }

    private static RepositoryInitializer createCompositeInitializer() {
        ServiceLoader<RepositoryInitializer> loader = ServiceLoader.load(RepositoryInitializer.class);
        ArrayList<RepositoryInitializer> initializers = Lists.newArrayList(loader.iterator());
        return new CompositeInitializer(initializers);
    }
}

