/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.upgrade.cli;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closer;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.oak.plugins.blob.datastore.DataStoreBlobStore;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.upgrade.RepositorySidegrade;
import org.apache.jackrabbit.oak.upgrade.RepositoryUpgrade;
import org.apache.jackrabbit.oak.upgrade.cli.parser.CliArgumentException;
import org.apache.jackrabbit.oak.upgrade.cli.parser.DatastoreArguments;
import org.apache.jackrabbit.oak.upgrade.cli.parser.MigrationOptions;
import org.apache.jackrabbit.oak.upgrade.cli.parser.StoreArguments;

public class MigrationFactory {
    protected final MigrationOptions options;
    protected final StoreArguments stores;
    protected final DatastoreArguments datastores;
    protected final Closer closer;

    public MigrationFactory(MigrationOptions options, StoreArguments stores, DatastoreArguments datastores, Closer closer) {
        this.options = options;
        this.stores = stores;
        this.datastores = datastores;
        this.closer = closer;
    }

    public RepositoryUpgrade createUpgrade() throws IOException, RepositoryException, CliArgumentException {
        RepositoryContext src = this.stores.getSrcStore().create(this.closer);
        DataStoreBlobStore srcBlobStore = new DataStoreBlobStore(src.getDataStore());
        NodeStore dstStore = this.createTarget(this.closer, srcBlobStore);
        return this.createUpgrade(src, dstStore);
    }

    public RepositorySidegrade createSidegrade() throws IOException, CliArgumentException {
        BlobStore srcBlobStore = this.datastores.getSrcBlobStore().create(this.closer);
        NodeStore srcStore = this.stores.getSrcStore().create(srcBlobStore, this.closer);
        NodeStore dstStore = this.createTarget(this.closer, srcBlobStore);
        return this.createSidegrade(srcStore, dstStore);
    }

    protected NodeStore createTarget(Closer closer, BlobStore srcBlobStore) throws IOException {
        BlobStore dstBlobStore = this.datastores.getDstBlobStore(srcBlobStore).create(closer);
        NodeStore dstStore = this.stores.getDstStore().create(dstBlobStore, closer);
        return dstStore;
    }

    protected RepositoryUpgrade createUpgrade(RepositoryContext source, NodeStore dstStore) {
        RepositoryUpgrade upgrade = new RepositoryUpgrade(source, dstStore);
        upgrade.setCopyBinariesByReference(this.datastores.getBlobMigrationCase() == DatastoreArguments.BlobMigrationCase.COPY_REFERENCES);
        upgrade.setCopyVersions(this.options.getCopyVersions());
        upgrade.setCopyOrphanedVersions(this.options.getCopyOrphanedVersions());
        if (this.options.getIncludePaths() != null) {
            upgrade.setIncludes(this.options.getIncludePaths());
        }
        if (this.options.getExcludePaths() != null) {
            upgrade.setExcludes(this.options.getExcludePaths());
        }
        if (this.options.getMergePaths() != null) {
            upgrade.setMerges(this.options.getMergePaths());
        }
        upgrade.setFilterLongNames(!this.stores.getDstType().isSupportLongNames());
        upgrade.setCheckLongNames(!this.options.isSkipNameCheck() && !this.stores.getDstType().isSupportLongNames());
        upgrade.setSkipOnError(!this.options.isFailOnError());
        upgrade.setEarlyShutdown(this.options.isEarlyShutdown());
        upgrade.setSkipInitialization(this.options.isSkipInitialization());
        ServiceLoader<CommitHook> loader = ServiceLoader.load(CommitHook.class);
        Iterator<CommitHook> iterator = loader.iterator();
        ImmutableCollection.Builder builder = ImmutableList.builder().addAll(iterator);
        upgrade.setCustomCommitHooks((List<CommitHook>)((Object)((ImmutableList.Builder)builder).build()));
        return upgrade;
    }

    private RepositorySidegrade createSidegrade(NodeStore srcStore, NodeStore dstStore) {
        RepositorySidegrade sidegrade = new RepositorySidegrade(srcStore, dstStore);
        sidegrade.setCopyVersions(this.options.getCopyVersions());
        sidegrade.setCopyOrphanedVersions(this.options.getCopyOrphanedVersions());
        if (this.options.getIncludePaths() != null) {
            sidegrade.setIncludes(this.options.getIncludePaths());
        }
        if (this.options.getExcludePaths() != null) {
            sidegrade.setExcludes(this.options.getExcludePaths());
        }
        if (this.options.getMergePaths() != null) {
            sidegrade.setMerges(this.options.getMergePaths());
        }
        sidegrade.setFilterLongNames(this.stores.getSrcType().isSupportLongNames() && !this.stores.getDstType().isSupportLongNames());
        sidegrade.setSkipInitialization(this.options.isSkipInitialization());
        sidegrade.setIncludeIndex(this.options.isIncludeIndex());
        return sidegrade;
    }
}

