/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.upgrade.cli;

import com.google.common.io.Closer;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.oak.upgrade.cli.OakUpgrade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CliUtils {
    private static final Logger log = LoggerFactory.getLogger(OakUpgrade.class);

    public static void displayUsage() throws IOException {
        System.out.println(CliUtils.getUsage().replace("${command}", "java -jar oak-run-*-jr2.jar upgrade"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUsage() throws IOException {
        InputStream is = CliUtils.class.getClassLoader().getResourceAsStream("upgrade_usage.txt");
        try {
            String string = IOUtils.toString(is);
            return string;
        }
        finally {
            IOUtils.closeQuietly(is);
        }
    }

    public static void handleSigInt(final Closer closer) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    closer.close();
                }
                catch (IOException e) {
                    log.error("Can't close", e);
                }
            }
        });
    }
}

