/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.upgrade.blob;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.jackrabbit.core.data.AbstractDataRecord;
import org.apache.jackrabbit.core.data.AbstractDataStore;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LengthCachingDataStore
extends AbstractDataStore {
    private static final Logger log = LoggerFactory.getLogger(LengthCachingDataStore.class);
    public static final char SEPARATOR = '|';
    private Map<String, Long> existingMappings = Collections.emptyMap();
    private Map<String, Long> newMappings = Maps.newConcurrentMap();
    private String mappingFilePath = "datastore-list.txt";
    private String delegateClass;
    private String delegateConfigFilePath;
    private DataStore delegate;
    private boolean readOnly = true;
    private File mappingFile;

    @Override
    public void init(String homeDir) throws RepositoryException {
        this.initializeDelegate(homeDir);
        this.initializeMappingData(homeDir);
    }

    @Override
    public DataRecord getRecordIfStored(DataIdentifier dataIdentifier) throws DataStoreException {
        if (this.existingMappings.containsKey(dataIdentifier.toString())) {
            return new DelegateDataRecord(this, dataIdentifier, this.existingMappings);
        }
        if (this.newMappings.containsKey(dataIdentifier.toString())) {
            return new DelegateDataRecord(this, dataIdentifier, this.newMappings);
        }
        DataRecord result = this.getDelegate().getRecordIfStored(dataIdentifier);
        this.addNewMapping(result);
        return result;
    }

    @Override
    public DataRecord getRecordFromReference(String reference) throws DataStoreException {
        int colon;
        if (reference != null && (colon = reference.indexOf(58)) != -1) {
            return this.getRecordIfStored(new DataIdentifier(reference.substring(0, colon)));
        }
        return null;
    }

    @Override
    public DataRecord addRecord(InputStream inputStream) throws DataStoreException {
        this.checkIfReadOnly();
        DataRecord result = this.getDelegate().addRecord(inputStream);
        this.addNewMapping(result);
        return result;
    }

    @Override
    public void updateModifiedDateOnAccess(long before) {
        this.checkIfReadOnly();
        this.getDelegate().updateModifiedDateOnAccess(before);
    }

    @Override
    public int deleteAllOlderThan(long min) throws DataStoreException {
        this.checkIfReadOnly();
        return this.getDelegate().deleteAllOlderThan(min);
    }

    @Override
    public Iterator<DataIdentifier> getAllIdentifiers() throws DataStoreException {
        return this.getDelegate().getAllIdentifiers();
    }

    @Override
    public int getMinRecordLength() {
        return this.getDelegate().getMinRecordLength();
    }

    @Override
    public void close() throws DataStoreException {
        this.existingMappings.clear();
        this.saveNewMappingsToFile();
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    @Override
    public void clearInUse() {
        this.getDelegate().clearInUse();
    }

    File getMappingFile() {
        return this.mappingFile;
    }

    public void setMappingFilePath(String mappingFilePath) {
        this.mappingFilePath = mappingFilePath;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setDelegateClass(String delegateClass) {
        this.delegateClass = delegateClass;
    }

    public void setDelegateConfigFilePath(String delegateConfigFilePath) {
        this.delegateConfigFilePath = delegateConfigFilePath;
    }

    private void checkIfReadOnly() {
        Preconditions.checkState(!this.readOnly, "Read only DataStore in use");
    }

    private DataStore getDelegate() {
        return Preconditions.checkNotNull(this.delegate, "Delegate DataStore not configured");
    }

    private void addNewMapping(DataRecord dr) throws DataStoreException {
        if (dr != null) {
            this.newMappings.put(dr.getIdentifier().toString(), dr.getLength());
        }
    }

    private void initializeMappingData(String homeDir) {
        this.mappingFile = new File(FilenameUtils.concat(homeDir, this.mappingFilePath));
        if (this.mappingFile.exists()) {
            try {
                this.existingMappings = LengthCachingDataStore.loadMappingData(this.mappingFile);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Failed to read mapping data from " + this.mappingFile, e);
            }
        } else {
            log.info("Mapping file {} not found. Would create a new one.", (Object)this.mappingFile);
        }
    }

    private void initializeDelegate(String homeDir) throws RepositoryException {
        Preconditions.checkNotNull(this.delegateClass, "No delegate DataStore class defined via 'delegateClass' property");
        try {
            this.delegate = (DataStore)this.getClass().getClassLoader().loadClass(this.delegateClass).newInstance();
        }
        catch (InstantiationException e) {
            throw new RepositoryException("Cannot load delegate class " + this.delegateClass, e);
        }
        catch (IllegalAccessException e) {
            throw new RepositoryException("Cannot load delegate class " + this.delegateClass, e);
        }
        catch (ClassNotFoundException e) {
            throw new RepositoryException("Cannot load delegate class " + this.delegateClass, e);
        }
        log.info("Using {} as the delegating DataStore", (Object)this.delegateClass);
        if (this.delegateConfigFilePath != null) {
            File configFile = new File(this.delegateConfigFilePath);
            Preconditions.checkArgument(configFile.exists(), "Delegate DataStore config file %s does not exist", configFile.getAbsolutePath());
            InputStream is = null;
            try {
                Properties props = new Properties();
                is = Files.newInputStreamSupplier(configFile).getInput();
                props.load(is);
                PropertiesUtil.populate(this.delegate, LengthCachingDataStore.propsToMap(props), false);
                log.info("Configured the delegating DataStore via {}", (Object)configFile.getAbsolutePath());
            }
            catch (IOException e) {
                try {
                    throw new RepositoryException("Error reading from config file " + configFile.getAbsolutePath(), e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(is);
        }
        this.delegate.init(homeDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveNewMappingsToFile() {
        if (!this.newMappings.isEmpty()) {
            BufferedWriter w = null;
            try {
                w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.mappingFile, true), Charsets.UTF_8));
                for (Map.Entry<String, Long> e : this.newMappings.entrySet()) {
                    w.write(String.valueOf(e.getValue()));
                    w.write(124);
                    w.write(e.getKey());
                    w.newLine();
                }
                log.info("Added {} new entries to the mapping file {}", (Object)this.newMappings.size(), (Object)this.mappingFile);
                this.newMappings.clear();
                IOUtils.closeQuietly(w);
            }
            catch (IOException e) {
                log.warn("Error occurred while writing mapping data to {}", (Object)this.mappingFile, (Object)e);
            }
            finally {
                IOUtils.closeQuietly(w);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Long> loadMappingData(File mappingFile) throws FileNotFoundException {
        HashMap<String, Long> mapping = new HashMap<String, Long>();
        log.info("Reading mapping data from {}", (Object)mappingFile.getAbsolutePath());
        try (LineIterator itr = new LineIterator(Files.newReader(mappingFile, Charsets.UTF_8));){
            while (itr.hasNext()) {
                String line = itr.nextLine();
                int indexOfBar = line.indexOf(124);
                Preconditions.checkState(indexOfBar > 0, "Malformed entry found [%s]", line);
                String length = line.substring(0, indexOfBar);
                String id = line.substring(indexOfBar + 1);
                mapping.put(id.trim(), Long.valueOf(length));
            }
            log.info("Total {} mapping entries found", (Object)mapping.size());
        }
        return mapping;
    }

    private static Map<String, Object> propsToMap(Properties p) {
        HashMap<String, Object> result = Maps.newHashMap();
        for (String keyName : p.stringPropertyNames()) {
            result.put(keyName, p.getProperty(keyName));
        }
        return result;
    }

    private class DelegateDataRecord
    extends AbstractDataRecord {
        private final Map<String, Long> mapping;
        private DataRecord delegateRecord;

        public DelegateDataRecord(AbstractDataStore store, DataIdentifier identifier, Map<String, Long> recordSizeMapping) {
            super(store, identifier);
            this.mapping = recordSizeMapping;
        }

        @Override
        public long getLength() throws DataStoreException {
            Long size = this.mapping.get(this.getIdentifier().toString());
            if (size == null) {
                log.info("No size mapping found for {}. Checking with delegate", (Object)this.getIdentifier());
                return this.getDelegateRecord().getLength();
            }
            return size;
        }

        @Override
        public InputStream getStream() throws DataStoreException {
            return this.getDelegateRecord().getStream();
        }

        @Override
        public long getLastModified() {
            try {
                return this.getDelegateRecord().getLastModified();
            }
            catch (DataStoreException e) {
                throw new RuntimeException(e);
            }
        }

        private DataRecord getDelegateRecord() throws DataStoreException {
            if (this.delegateRecord == null) {
                this.delegateRecord = LengthCachingDataStore.this.getDelegate().getRecord(this.getIdentifier());
            }
            return this.delegateRecord;
        }
    }
}

