/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.upgrade;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.plugins.nodetype.TypePredicate;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.DefaultEditor;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.commit.EditorProvider;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SameNameSiblingsEditor
extends DefaultEditor {
    private static final Logger logger = LoggerFactory.getLogger(SameNameSiblingsEditor.class);
    private static final Pattern SNS_REGEX = Pattern.compile("^(.+)\\[(\\d+)\\]$");
    private static final Predicate<NodeState> NO_SNS_PROPERTY = new Predicate<NodeState>(){

        @Override
        public boolean apply(NodeState input) {
            return !input.getBoolean("jcr:sameNameSiblings");
        }
    };
    private final List<ChildTypeDef> childrenDefsWithoutSns;
    private final NodeBuilder builder;
    private final String path;

    public SameNameSiblingsEditor(NodeBuilder rootBuilder) {
        this.childrenDefsWithoutSns = SameNameSiblingsEditor.prepareChildDefsWithoutSns(rootBuilder.getNodeState());
        this.builder = rootBuilder;
        this.path = "";
    }

    public SameNameSiblingsEditor(SameNameSiblingsEditor parent, String name, NodeBuilder builder) {
        this.childrenDefsWithoutSns = parent.childrenDefsWithoutSns;
        this.builder = builder;
        this.path = parent.path + '/' + name;
    }

    @Override
    public Editor childNodeAdded(String name, NodeState after) throws CommitFailedException {
        return new SameNameSiblingsEditor(this, name, this.builder.getChildNode(name));
    }

    @Override
    public Editor childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
        return new SameNameSiblingsEditor(this, name, this.builder.getChildNode(name));
    }

    @Override
    public void leave(NodeState before, NodeState after) throws CommitFailedException {
        if (this.hasSameNamedChildren(after)) {
            this.renameSameNamedChildren(this.builder);
        }
    }

    private static List<ChildTypeDef> prepareChildDefsWithoutSns(NodeState root) {
        ArrayList<ChildTypeDef> defs = new ArrayList<ChildTypeDef>();
        NodeState types = root.getChildNode("jcr:system").getChildNode("jcr:nodeTypes");
        for (ChildNodeEntry childNodeEntry : types.getChildNodeEntries()) {
            NodeState type = childNodeEntry.getNodeState();
            TypePredicate typePredicate = new TypePredicate(root, childNodeEntry.getName());
            defs.addAll(SameNameSiblingsEditor.parseResidualChildNodeDefs(root, type, typePredicate));
            defs.addAll(SameNameSiblingsEditor.parseNamedChildNodeDefs(root, type, typePredicate));
        }
        return defs;
    }

    private static List<ChildTypeDef> parseNamedChildNodeDefs(NodeState root, NodeState parentType, TypePredicate parentTypePredicate) {
        ArrayList<ChildTypeDef> defs = new ArrayList<ChildTypeDef>();
        NodeState namedChildNodeDefinitions = parentType.getChildNode("rep:namedChildNodeDefinitions");
        for (ChildNodeEntry childNodeEntry : namedChildNodeDefinitions.getChildNodeEntries()) {
            for (String childType : SameNameSiblingsEditor.filterChildren(childNodeEntry.getNodeState(), NO_SNS_PROPERTY)) {
                TypePredicate childTypePredicate = new TypePredicate(root, childType);
                defs.add(new ChildTypeDef(parentTypePredicate, childNodeEntry.getName(), childTypePredicate));
            }
        }
        return defs;
    }

    private static List<ChildTypeDef> parseResidualChildNodeDefs(NodeState root, NodeState parentType, TypePredicate parentTypePredicate) {
        ArrayList<ChildTypeDef> defs = new ArrayList<ChildTypeDef>();
        NodeState resChildNodeDefinitions = parentType.getChildNode("rep:residualChildNodeDefinitions");
        for (String childType : SameNameSiblingsEditor.filterChildren(resChildNodeDefinitions, NO_SNS_PROPERTY)) {
            TypePredicate childTypePredicate = new TypePredicate(root, childType);
            defs.add(new ChildTypeDef(parentTypePredicate, childTypePredicate));
        }
        return defs;
    }

    private static Iterable<String> filterChildren(NodeState parent, final Predicate<NodeState> predicate) {
        return Iterables.transform(Iterables.filter(parent.getChildNodeEntries(), new Predicate<ChildNodeEntry>(){

            @Override
            public boolean apply(ChildNodeEntry input) {
                return predicate.apply(input.getNodeState());
            }
        }), new Function<ChildNodeEntry, String>(){

            @Override
            public String apply(ChildNodeEntry input) {
                return input.getName();
            }
        });
    }

    private boolean hasSameNamedChildren(NodeState parent) {
        for (String name : parent.getChildNodeNames()) {
            if (!SNS_REGEX.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    private void renameSameNamedChildren(NodeBuilder parent) {
        NodeState parentNode = parent.getNodeState();
        HashMap<String, String> toBeRenamed = new HashMap<String, String>();
        for (String string : parent.getChildNodeNames()) {
            Matcher m = SNS_REGEX.matcher(string);
            if (!m.matches() || this.isSnsAllowedForChild(parentNode, string)) continue;
            String prefix = m.group(1);
            String index = m.group(2);
            toBeRenamed.put(string, this.createNewName(parentNode, prefix, index));
        }
        for (Map.Entry entry : toBeRenamed.entrySet()) {
            logger.warn("Renaming SNS {}/{} to {}", this.path, entry.getKey(), entry.getValue());
            parent.getChildNode((String)entry.getKey()).moveTo(parent, (String)entry.getValue());
        }
    }

    private boolean isSnsAllowedForChild(NodeState parent, String name) {
        for (ChildTypeDef snsDef : this.childrenDefsWithoutSns) {
            if (!snsDef.applies(parent, name)) continue;
            return false;
        }
        return true;
    }

    private String createNewName(NodeState parent, String prefix, String index) {
        String newName;
        int i = 1;
        do {
            newName = i == 1 ? String.format("%s_%s_", prefix, index) : String.format("%s_%s_%d", prefix, index, i);
            ++i;
        } while (parent.getChildNode(newName).exists());
        return newName;
    }

    private static class ChildTypeDef {
        private final TypePredicate parentType;
        private final String childNameConstraint;
        private final TypePredicate childType;

        public ChildTypeDef(TypePredicate parentType, String childName, TypePredicate childType) {
            this.parentType = parentType;
            this.childNameConstraint = childName;
            this.childType = childType;
        }

        public ChildTypeDef(TypePredicate parentType, TypePredicate childType) {
            this(parentType, null, childType);
        }

        public boolean applies(NodeState parent, String childName) {
            boolean result = true;
            result &= this.parentType.apply(parent);
            result &= this.childNameConstraint == null || childName.startsWith(this.childNameConstraint + '[');
            return result &= this.childType.apply(parent.getChildNode(childName));
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append(this.parentType.toString()).append(" > ");
            if (this.childNameConstraint == null) {
                result.append("*");
            } else {
                result.append(this.childNameConstraint);
            }
            result.append(this.childType.toString());
            return result.toString();
        }
    }

    public static class Provider
    implements EditorProvider {
        @Override
        public Editor getRootEditor(NodeState before, NodeState after, NodeBuilder builder, CommitInfo info) throws CommitFailedException {
            return new SameNameSiblingsEditor(builder);
        }
    }
}

