/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.upgrade;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.NodeDefinitionTemplate;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.NodeTypeTemplate;
import javax.jcr.nodetype.PropertyDefinitionTemplate;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import org.apache.jackrabbit.core.IndexAccessor;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.config.BeanConfig;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.core.config.SecurityConfig;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.security.authorization.PrivilegeRegistry;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.index.CompositeIndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdate;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.IndexUtils;
import org.apache.jackrabbit.oak.plugins.index.property.PropertyIndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.reference.ReferenceEditorProvider;
import org.apache.jackrabbit.oak.plugins.name.Namespaces;
import org.apache.jackrabbit.oak.plugins.nodetype.TypeEditorProvider;
import org.apache.jackrabbit.oak.plugins.nodetype.write.InitialContent;
import org.apache.jackrabbit.oak.plugins.nodetype.write.ReadWriteNodeTypeManager;
import org.apache.jackrabbit.oak.plugins.value.ValueFactoryImpl;
import org.apache.jackrabbit.oak.security.SecurityProviderImpl;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.CompositeEditorProvider;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.commit.EditorHook;
import org.apache.jackrabbit.oak.spi.commit.EditorProvider;
import org.apache.jackrabbit.oak.spi.commit.ProgressNotificationEditor;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.lifecycle.WorkspaceInitializer;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeConfiguration;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.upgrade.AsciiArtTicker;
import org.apache.jackrabbit.oak.upgrade.JackrabbitNodeState;
import org.apache.jackrabbit.oak.upgrade.SameNameSiblingsEditor;
import org.apache.jackrabbit.oak.upgrade.UpgradeRoot;
import org.apache.jackrabbit.oak.upgrade.nodestate.FilteringNodeState;
import org.apache.jackrabbit.oak.upgrade.nodestate.NameFilteringNodeState;
import org.apache.jackrabbit.oak.upgrade.nodestate.NodeStateCopier;
import org.apache.jackrabbit.oak.upgrade.nodestate.report.LoggingReporter;
import org.apache.jackrabbit.oak.upgrade.nodestate.report.ReportingNodeState;
import org.apache.jackrabbit.oak.upgrade.security.GroupEditorProvider;
import org.apache.jackrabbit.oak.upgrade.security.RestrictionEditorProvider;
import org.apache.jackrabbit.oak.upgrade.version.VersionCopier;
import org.apache.jackrabbit.oak.upgrade.version.VersionCopyConfiguration;
import org.apache.jackrabbit.oak.upgrade.version.VersionHistoryUtil;
import org.apache.jackrabbit.oak.upgrade.version.VersionableEditor;
import org.apache.jackrabbit.oak.upgrade.version.VersionablePropertiesEditor;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueConstraint;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryUpgrade {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryUpgrade.class);
    private static final int LOG_NODE_COPY = Integer.getInteger("oak.upgrade.logNodeCopy", 10000);
    private static final Set<String> INDEXES_TO_REBUILD = ImmutableSet.of("counter", "uuid");
    public static final Set<String> DEFAULT_INCLUDE_PATHS = FilteringNodeState.ALL;
    public static final Set<String> DEFAULT_EXCLUDE_PATHS = FilteringNodeState.NONE;
    public static final Set<String> DEFAULT_MERGE_PATHS = FilteringNodeState.NONE;
    private final RepositoryContext source;
    private final NodeStore target;
    private Set<String> includePaths = DEFAULT_INCLUDE_PATHS;
    private Set<String> excludePaths = DEFAULT_EXCLUDE_PATHS;
    private Set<String> mergePaths = DEFAULT_MERGE_PATHS;
    private boolean copyBinariesByReference = false;
    private boolean skipOnError = false;
    private boolean earlyShutdown = false;
    private List<CommitHook> customCommitHooks = null;
    private boolean checkLongNames = false;
    private boolean filterLongNames = true;
    private boolean skipInitialization = false;
    VersionCopyConfiguration versionCopyConfiguration = new VersionCopyConfiguration();

    public static void copy(File source, NodeStore target) throws RepositoryException {
        RepositoryUpgrade.copy(RepositoryConfig.create(source), target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(RepositoryConfig source, NodeStore target) throws RepositoryException {
        RepositoryContext context = RepositoryContext.create(source);
        try {
            new RepositoryUpgrade(context, target).copy(null);
        }
        finally {
            context.getRepository().shutdown();
        }
    }

    public RepositoryUpgrade(RepositoryContext source, NodeStore target) {
        this.source = source;
        this.target = target;
    }

    public boolean isCopyBinariesByReference() {
        return this.copyBinariesByReference;
    }

    public void setCopyBinariesByReference(boolean copyBinariesByReference) {
        this.copyBinariesByReference = copyBinariesByReference;
    }

    public boolean isSkipOnError() {
        return this.skipOnError;
    }

    public void setSkipOnError(boolean skipOnError) {
        this.skipOnError = skipOnError;
    }

    public boolean isEarlyShutdown() {
        return this.earlyShutdown;
    }

    public void setEarlyShutdown(boolean earlyShutdown) {
        this.earlyShutdown = earlyShutdown;
    }

    public boolean isCheckLongNames() {
        return this.checkLongNames;
    }

    public void setCheckLongNames(boolean checkLongNames) {
        this.checkLongNames = checkLongNames;
    }

    public boolean isFilterLongNames() {
        return this.filterLongNames;
    }

    public void setFilterLongNames(boolean filterLongNames) {
        this.filterLongNames = filterLongNames;
    }

    public boolean isSkipInitialization() {
        return this.skipInitialization;
    }

    public void setSkipInitialization(boolean skipInitialization) {
        this.skipInitialization = skipInitialization;
    }

    public List<CommitHook> getCustomCommitHooks() {
        return this.customCommitHooks;
    }

    public void setCustomCommitHooks(List<CommitHook> customCommitHooks) {
        this.customCommitHooks = customCommitHooks;
    }

    public void setIncludes(String ... includes) {
        this.includePaths = ImmutableSet.copyOf((Object[])Preconditions.checkNotNull(includes));
    }

    public void setExcludes(String ... excludes) {
        this.excludePaths = ImmutableSet.copyOf((Object[])Preconditions.checkNotNull(excludes));
    }

    public void setMerges(String ... merges) {
        this.mergePaths = ImmutableSet.copyOf((Object[])Preconditions.checkNotNull(merges));
    }

    public void setCopyVersions(Calendar minDate) {
        this.versionCopyConfiguration.setCopyVersions(minDate);
    }

    public void setCopyOrphanedVersions(Calendar minDate) {
        this.versionCopyConfiguration.setCopyOrphanedVersions(minDate);
    }

    public void copy(RepositoryInitializer initializer) throws RepositoryException {
        if (this.checkLongNames) {
            this.assertNoLongNames();
        }
        RepositoryConfig config = this.source.getRepositoryConfig();
        logger.info("Copying repository content from {} to Oak", (Object)config.getHomeDir());
        try {
            NodeBuilder targetBuilder = this.target.getRoot().builder();
            final UpgradeRoot upgradeRoot = new UpgradeRoot(targetBuilder);
            String workspaceName = this.source.getRepositoryConfig().getDefaultWorkspaceName();
            SecurityProviderImpl security = new SecurityProviderImpl(this.mapSecurityConfig(config.getSecurityConfig()));
            if (this.skipInitialization) {
                logger.info("Skipping the repository initialization");
            } else {
                logger.info("Initializing initial repository content from {}", (Object)config.getHomeDir());
                new InitialContent().initialize(targetBuilder);
                if (initializer != null) {
                    initializer.initialize(targetBuilder);
                }
                logger.debug("InitialContent completed from {}", (Object)config.getHomeDir());
                for (SecurityConfiguration securityConfiguration : security.getConfigurations()) {
                    RepositoryInitializer ri = securityConfiguration.getRepositoryInitializer();
                    ri.initialize(targetBuilder);
                    logger.debug("Repository initializer '" + ri.getClass().getName() + "' completed", (Object)config.getHomeDir());
                }
                for (SecurityConfiguration securityConfiguration : security.getConfigurations()) {
                    WorkspaceInitializer wi = securityConfiguration.getWorkspaceInitializer();
                    wi.initialize(targetBuilder, workspaceName);
                    logger.debug("Workspace initializer '" + wi.getClass().getName() + "' completed", (Object)config.getHomeDir());
                }
            }
            HashBiMap<String, String> uriToPrefix = HashBiMap.create();
            logger.info("Copying registered namespaces");
            this.copyNamespaces(targetBuilder, uriToPrefix);
            logger.debug("Namespace registration completed.");
            if (this.skipInitialization) {
                logger.info("Skipping registering node types and privileges");
            } else {
                logger.info("Copying registered node types");
                ReadWriteNodeTypeManager readWriteNodeTypeManager = new ReadWriteNodeTypeManager(){

                    @Override
                    protected Tree getTypes() {
                        return upgradeRoot.getTree("/jcr:system/jcr:nodeTypes");
                    }

                    @Override
                    @Nonnull
                    protected Root getWriteRoot() {
                        return upgradeRoot;
                    }
                };
                this.copyNodeTypes(readWriteNodeTypeManager, new ValueFactoryImpl(upgradeRoot, NamePathMapper.DEFAULT));
                logger.debug("Node type registration completed.");
                logger.info("Copying registered privileges");
                PrivilegeConfiguration privilegeConfiguration = security.getConfiguration(PrivilegeConfiguration.class);
                this.copyCustomPrivileges(privilegeConfiguration.getPrivilegeManager(upgradeRoot, NamePathMapper.DEFAULT));
                logger.debug("Privilege registration completed.");
                new TypeEditorProvider(false).getRootEditor(targetBuilder.getBaseState(), targetBuilder.getNodeState(), targetBuilder, null);
            }
            NodeState nodeState = ReportingNodeState.wrap(JackrabbitNodeState.createRootNodeState(this.source, workspaceName, targetBuilder.getNodeState(), uriToPrefix, this.copyBinariesByReference, this.skipOnError), new LoggingReporter(logger, "Migrating", LOG_NODE_COPY, -1));
            NodeState sourceRoot = this.filterLongNames ? NameFilteringNodeState.wrap(nodeState) : nodeState;
            Stopwatch watch = Stopwatch.createStarted();
            logger.info("Copying workspace content");
            this.copyWorkspace(sourceRoot, targetBuilder, workspaceName);
            targetBuilder.getNodeState();
            logger.info("Upgrading workspace content completed in {}s ({})", (Object)watch.elapsed(TimeUnit.SECONDS), (Object)watch);
            if (!this.versionCopyConfiguration.skipOrphanedVersionsCopy()) {
                logger.info("Copying version storage");
                watch.reset().start();
                VersionCopier.copyVersionStorage(targetBuilder, VersionHistoryUtil.getVersionStorage(sourceRoot), VersionHistoryUtil.getVersionStorage(targetBuilder), this.versionCopyConfiguration);
                targetBuilder.getNodeState();
                logger.info("Version storage copied in {}s ({})", (Object)watch.elapsed(TimeUnit.SECONDS), (Object)watch);
            } else {
                logger.info("Skipping the version storage as the copyOrphanedVersions is set to false");
            }
            watch.reset().start();
            logger.info("Applying default commit hooks");
            ArrayList<CommitHook> hooks = Lists.newArrayList();
            UserConfiguration userConf = security.getConfiguration(UserConfiguration.class);
            String groupsPath = userConf.getParameters().getConfigValue("groupsPath", "/rep:security/rep:authorizables/rep:groups");
            hooks.add(new EditorHook(new CompositeEditorProvider(new RestrictionEditorProvider(), new GroupEditorProvider(groupsPath), new VersionableEditor.Provider(sourceRoot, workspaceName, this.versionCopyConfiguration), new SameNameSiblingsEditor.Provider())));
            hooks.add(new EditorHook(new VersionablePropertiesEditor.Provider()));
            for (SecurityConfiguration securityConfiguration : security.getConfigurations()) {
                hooks.addAll(securityConfiguration.getCommitHooks(workspaceName));
            }
            if (this.customCommitHooks != null) {
                hooks.addAll(this.customCommitHooks);
            }
            RepositoryUpgrade.markIndexesToBeRebuilt(targetBuilder);
            hooks.add(new EditorHook(new CompositeEditorProvider(RepositoryUpgrade.createTypeEditorProvider(), RepositoryUpgrade.createIndexEditorProvider())));
            this.target.merge(targetBuilder, new LoggingCompositeHook(hooks, this.source, this.overrideEarlyShutdown()), CommitInfo.EMPTY);
            logger.info("Processing commit hooks completed in {}s ({})", (Object)watch.elapsed(TimeUnit.SECONDS), (Object)watch);
            logger.debug("Repository upgrade completed.");
        }
        catch (Exception e) {
            throw new RepositoryException("Failed to copy content", e);
        }
    }

    static void markIndexesToBeRebuilt(NodeBuilder targetRoot) {
        NodeBuilder oakIndex = IndexUtils.getOrCreateOakIndex(targetRoot);
        for (String indexName : INDEXES_TO_REBUILD) {
            NodeBuilder indexDef = oakIndex.getChildNode(indexName);
            if (!indexDef.exists()) continue;
            PropertyState reindex = indexDef.getProperty("reindex");
            logger.info("Marking {} to be reindexed", (Object)indexName);
            if (reindex != null && reindex.getValue(Type.BOOLEAN).booleanValue()) continue;
            indexDef.setProperty("reindex", true);
        }
    }

    private boolean overrideEarlyShutdown() {
        if (!this.earlyShutdown) {
            return false;
        }
        VersionCopyConfiguration c = this.versionCopyConfiguration;
        if (c.isCopyVersions() && c.skipOrphanedVersionsCopy()) {
            logger.info("Overriding early shutdown to false because of the copy versions settings");
            return false;
        }
        if (c.isCopyVersions() && !c.skipOrphanedVersionsCopy() && c.getOrphanedMinDate().after(c.getVersionsMinDate())) {
            logger.info("Overriding early shutdown to false because of the copy versions settings");
            return false;
        }
        return true;
    }

    static EditorProvider createTypeEditorProvider() {
        return new EditorProvider(){

            @Override
            public Editor getRootEditor(NodeState before, NodeState after, NodeBuilder builder, CommitInfo info) throws CommitFailedException {
                Editor rootEditor = new TypeEditorProvider(false).getRootEditor(before, after, builder, info);
                return ProgressNotificationEditor.wrap(rootEditor, logger, "Checking node types:");
            }

            public String toString() {
                return "TypeEditorProvider";
            }
        };
    }

    static EditorProvider createIndexEditorProvider() {
        final AsciiArtTicker ticker = new AsciiArtTicker();
        return new EditorProvider(){

            @Override
            public Editor getRootEditor(NodeState before, NodeState after, NodeBuilder builder, CommitInfo info) {
                CompositeIndexEditorProvider editorProviders = new CompositeIndexEditorProvider(new ReferenceEditorProvider(), new PropertyIndexEditorProvider());
                return new IndexUpdate(editorProviders, null, after, builder, new IndexUpdateCallback(){
                    String progress = "Updating indexes ";
                    long t0;

                    @Override
                    public void indexUpdate() {
                        long t = System.currentTimeMillis();
                        if (t - this.t0 > 2000L) {
                            logger.info("{} {}", (Object)this.progress, (Object)ticker.tick());
                            this.t0 = t;
                        }
                    }
                });
            }

            public String toString() {
                return "IndexEditorProvider";
            }
        };
    }

    protected ConfigurationParameters mapSecurityConfig(SecurityConfig config) {
        ConfigurationParameters loginConfig = this.mapConfigurationParameters(config.getLoginModuleConfig(), "adminId", "adminId", "anonymousId", "anonymousId");
        ConfigurationParameters userConfig = config.getSecurityManagerConfig() == null ? ConfigurationParameters.EMPTY : this.mapConfigurationParameters(config.getSecurityManagerConfig().getUserManagerConfig(), "usersPath", "usersPath", "groupsPath", "groupsPath", "defaultDepth", "defaultDepth", "passwordHashAlgorithm", "passwordHashAlgorithm", "passwordHashIterations", "passwordHashIterations");
        return ConfigurationParameters.of(ImmutableMap.of("org.apache.jackrabbit.oak.user", ConfigurationParameters.of(loginConfig, userConfig)));
    }

    protected ConfigurationParameters mapConfigurationParameters(BeanConfig config, String ... mapping) {
        HashMap<String, String> map = Maps.newHashMap();
        if (config != null) {
            Properties properties = config.getParameters();
            int i = 0;
            while (i + 1 < mapping.length) {
                String value = properties.getProperty(mapping[i]);
                if (value != null) {
                    map.put(mapping[i + 1], value);
                }
                i += 2;
            }
        }
        return ConfigurationParameters.of(map);
    }

    private String getOakName(Name name) throws NamespaceException {
        String uri = name.getNamespaceURI();
        String local = name.getLocalName();
        if (uri == null || uri.isEmpty()) {
            return local;
        }
        return this.source.getNamespaceRegistry().getPrefix(uri) + ':' + local;
    }

    private void copyNamespaces(NodeBuilder targetRoot, Map<String, String> uriToPrefix) throws RepositoryException {
        NodeBuilder system = targetRoot.child("jcr:system");
        NodeBuilder namespaces = system.child("rep:namespaces");
        Properties registry = this.loadProperties("/namespaces/ns_reg.properties");
        for (String prefixHint : registry.stringPropertyNames()) {
            String uri = registry.getProperty(prefixHint);
            String prefix = ".empty.key".equals(prefixHint) ? "" : Namespaces.addCustomMapping(namespaces, uri, prefixHint);
            Preconditions.checkState(uriToPrefix.put(uri, prefix) == null);
        }
        Namespaces.buildIndexNode(namespaces);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(String path) throws RepositoryException {
        Properties properties;
        block6: {
            properties = new Properties();
            FileSystem filesystem = this.source.getFileSystem();
            try {
                if (!filesystem.exists(path)) break block6;
                try (InputStream stream = filesystem.getInputStream(path);){
                    properties.load(stream);
                }
            }
            catch (FileSystemException e) {
                throw new RepositoryException(e);
            }
            catch (IOException e) {
                throw new RepositoryException(e);
            }
        }
        return properties;
    }

    private void copyCustomPrivileges(PrivilegeManager pMgr) throws RepositoryException {
        PrivilegeRegistry registry = this.source.getPrivilegeRegistry();
        ArrayList<Privilege> customAggrPrivs = Lists.newArrayList();
        logger.debug("Registering custom non-aggregated privileges");
        for (Privilege privilege : registry.getRegisteredPrivileges()) {
            String privilegeName = privilege.getName();
            if (this.hasPrivilege(pMgr, privilegeName)) {
                logger.debug("Privilege {} already exists", (Object)privilegeName);
                continue;
            }
            if (PrivilegeBits.BUILT_IN.containsKey(privilegeName) || "jcr:all".equals(privilegeName)) {
                logger.debug("Built-in privilege -> ignore.");
                continue;
            }
            if (privilege.isAggregate()) {
                customAggrPrivs.add(privilege);
                continue;
            }
            pMgr.registerPrivilege(privilegeName, privilege.isAbstract(), new String[0]);
            logger.info("- " + privilegeName);
        }
        logger.debug("Registering custom aggregated privileges");
        while (!customAggrPrivs.isEmpty()) {
            Iterator it = customAggrPrivs.iterator();
            boolean progress = false;
            while (it.hasNext()) {
                Privilege aggrPriv = (Privilege)it.next();
                List<String> aggrNames = Lists.transform(ImmutableList.copyOf(aggrPriv.getDeclaredAggregatePrivileges()), new Function<Privilege, String>(){

                    @Override
                    @Nullable
                    public String apply(@Nullable Privilege input) {
                        return input == null ? null : input.getName();
                    }
                });
                if (!RepositoryUpgrade.allAggregatesRegistered(pMgr, aggrNames)) continue;
                pMgr.registerPrivilege(aggrPriv.getName(), aggrPriv.isAbstract(), aggrNames.toArray(new String[aggrNames.size()]));
                it.remove();
                logger.info("- " + aggrPriv.getName());
                progress = true;
            }
            if (progress) continue;
            break;
        }
        if (!customAggrPrivs.isEmpty()) {
            StringBuilder invalid = new StringBuilder("|");
            for (Privilege p : customAggrPrivs) {
                invalid.append(p.getName()).append('|');
            }
            throw new RepositoryException("Failed to register custom privileges. The following privileges contained an invalid aggregation:" + invalid);
        }
        logger.debug("Registration of custom privileges completed.");
    }

    private boolean hasPrivilege(PrivilegeManager pMgr, String privilegeName) throws RepositoryException {
        Privilege[] registeredPrivileges;
        for (Privilege registeredPrivilege : registeredPrivileges = pMgr.getRegisteredPrivileges()) {
            if (!registeredPrivilege.getName().equals(privilegeName)) continue;
            return true;
        }
        return false;
    }

    private static boolean allAggregatesRegistered(PrivilegeManager privilegeManager, List<String> aggrNames) {
        for (String name : aggrNames) {
            try {
                privilegeManager.getPrivilege(name);
            }
            catch (RepositoryException e) {
                return false;
            }
        }
        return true;
    }

    private void copyNodeTypes(NodeTypeManager ntMgr, ValueFactory valueFactory) throws RepositoryException {
        NodeTypeRegistry sourceRegistry = this.source.getNodeTypeRegistry();
        ArrayList<NodeTypeTemplate> templates = Lists.newArrayList();
        for (Name name : sourceRegistry.getRegisteredNodeTypes()) {
            String oakName = this.getOakName(name);
            if (ntMgr.hasNodeType(oakName)) continue;
            QNodeTypeDefinition def = sourceRegistry.getNodeTypeDef(name);
            templates.add(this.createNodeTypeTemplate(valueFactory, ntMgr, oakName, def));
        }
        ntMgr.registerNodeTypes(templates.toArray(new NodeTypeTemplate[templates.size()]), true);
    }

    private NodeTypeTemplate createNodeTypeTemplate(ValueFactory valueFactory, NodeTypeManager ntMgr, String oakName, QNodeTypeDefinition def) throws RepositoryException {
        Name[] supertypes;
        NodeTypeTemplate tmpl = ntMgr.createNodeTypeTemplate();
        tmpl.setName(oakName);
        tmpl.setAbstract(def.isAbstract());
        tmpl.setMixin(def.isMixin());
        tmpl.setOrderableChildNodes(def.hasOrderableChildNodes());
        tmpl.setQueryable(def.isQueryable());
        Name primaryItemName = def.getPrimaryItemName();
        if (primaryItemName != null) {
            tmpl.setPrimaryItemName(this.getOakName(primaryItemName));
        }
        if ((supertypes = def.getSupertypes()) != null && supertypes.length > 0) {
            ArrayList<String> names = Lists.newArrayListWithCapacity(supertypes.length);
            for (Name supertype : supertypes) {
                names.add(this.getOakName(supertype));
            }
            tmpl.setDeclaredSuperTypeNames(names.toArray(new String[names.size()]));
        }
        List propertyDefinitionTemplates = tmpl.getPropertyDefinitionTemplates();
        for (QPropertyDefinition qpd : def.getPropertyDefs()) {
            PropertyDefinitionTemplate pdt = this.createPropertyDefinitionTemplate(valueFactory, ntMgr, qpd);
            propertyDefinitionTemplates.add(pdt);
        }
        List nodeDefinitionTemplates = tmpl.getNodeDefinitionTemplates();
        for (QNodeDefinition qnd : def.getChildNodeDefs()) {
            NodeDefinitionTemplate ndt = this.createNodeDefinitionTemplate(ntMgr, qnd);
            nodeDefinitionTemplates.add(ndt);
        }
        return tmpl;
    }

    private NodeDefinitionTemplate createNodeDefinitionTemplate(NodeTypeManager ntMgr, QNodeDefinition def) throws RepositoryException {
        NodeDefinitionTemplate tmpl = ntMgr.createNodeDefinitionTemplate();
        Name name = def.getName();
        if (name != null) {
            tmpl.setName(this.getOakName(name));
        }
        tmpl.setAutoCreated(def.isAutoCreated());
        tmpl.setMandatory(def.isMandatory());
        tmpl.setOnParentVersion(def.getOnParentVersion());
        tmpl.setProtected(def.isProtected());
        tmpl.setSameNameSiblings(def.allowsSameNameSiblings());
        ArrayList<String> names = Lists.newArrayListWithCapacity(def.getRequiredPrimaryTypes().length);
        for (Name type : def.getRequiredPrimaryTypes()) {
            names.add(this.getOakName(type));
        }
        tmpl.setRequiredPrimaryTypeNames(names.toArray(new String[names.size()]));
        Name type = def.getDefaultPrimaryType();
        if (type != null) {
            tmpl.setDefaultPrimaryTypeName(this.getOakName(type));
        }
        return tmpl;
    }

    private PropertyDefinitionTemplate createPropertyDefinitionTemplate(ValueFactory valueFactory, NodeTypeManager ntMgr, QPropertyDefinition def) throws RepositoryException {
        QValue[] qValues;
        PropertyDefinitionTemplate tmpl = ntMgr.createPropertyDefinitionTemplate();
        Name name = def.getName();
        if (name != null) {
            tmpl.setName(this.getOakName(name));
        }
        tmpl.setAutoCreated(def.isAutoCreated());
        tmpl.setMandatory(def.isMandatory());
        tmpl.setOnParentVersion(def.getOnParentVersion());
        tmpl.setProtected(def.isProtected());
        tmpl.setRequiredType(def.getRequiredType());
        tmpl.setMultiple(def.isMultiple());
        tmpl.setAvailableQueryOperators(def.getAvailableQueryOperators());
        tmpl.setFullTextSearchable(def.isFullTextSearchable());
        tmpl.setQueryOrderable(def.isQueryOrderable());
        QValueConstraint[] qConstraints = def.getValueConstraints();
        if (qConstraints != null && qConstraints.length > 0) {
            String[] constraints = new String[qConstraints.length];
            for (int i = 0; i < qConstraints.length; ++i) {
                constraints[i] = qConstraints[i].getString();
            }
            tmpl.setValueConstraints(constraints);
        }
        if ((qValues = def.getDefaultValues()) != null) {
            DefaultNamePathResolver npResolver = new DefaultNamePathResolver(this.source.getNamespaceRegistry());
            Value[] vs = new Value[qValues.length];
            for (int i = 0; i < qValues.length; ++i) {
                vs[i] = ValueFormat.getJCRValue(qValues[i], npResolver, valueFactory);
            }
            tmpl.setDefaultValues(vs);
        }
        return tmpl;
    }

    private String copyWorkspace(NodeState sourceRoot, NodeBuilder targetRoot, String workspaceName) throws RepositoryException {
        Set<String> includes = RepositoryUpgrade.calculateEffectiveIncludePaths(this.includePaths, sourceRoot);
        Sets.SetView<String> excludes = Sets.union(ImmutableSet.copyOf(this.excludePaths), ImmutableSet.of("/jcr:system/jcr:versionStorage"));
        Sets.SetView<String> merges = Sets.union(ImmutableSet.copyOf(this.mergePaths), ImmutableSet.of("/jcr:system"));
        logger.info("Copying workspace {} [i: {}, e: {}, m: {}]", workspaceName, includes, excludes, merges);
        NodeStateCopier.builder().include(includes).exclude(excludes).merge(merges).copy(sourceRoot, targetRoot);
        if (this.includePaths.contains("/")) {
            NodeStateCopier.copyProperties(sourceRoot, targetRoot);
        }
        return workspaceName;
    }

    static Set<String> calculateEffectiveIncludePaths(Set<String> includePaths, NodeState sourceRoot) {
        if (!includePaths.contains("/")) {
            return ImmutableSet.copyOf(includePaths);
        }
        HashSet<String> includes = Sets.newHashSet();
        for (String childNodeName : sourceRoot.getChildNodeNames()) {
            includes.add("/" + childNodeName);
        }
        return includes;
    }

    void assertNoLongNames() throws RepositoryException {
        Session session = this.source.getRepository().login(null, null);
        boolean longNameFound = false;
        try {
            IndexReader reader = IndexAccessor.getReader(this.source);
            if (reader == null) {
                return;
            }
            TermEnum terms = reader.terms(new Term(FieldNames.LOCAL_NAME));
            while (terms.next()) {
                TermDocs docs;
                String name;
                Term t = terms.term();
                if (!FieldNames.LOCAL_NAME.equals(t.field()) || !NameFilteringNodeState.isNameTooLong(name = t.text()) || !(docs = reader.termDocs(t)).next()) continue;
                int docId = docs.doc();
                String uuid = reader.document(docId).get(FieldNames.UUID);
                Node n = session.getNodeByIdentifier(uuid);
                logger.warn("Name too long: {}", (Object)n.getPath());
                longNameFound = true;
            }
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        finally {
            session.logout();
        }
        if (longNameFound) {
            logger.error("Node with a long name has been found. Please fix the content or rerun the migration with {} option.", (Object)"skip-name-check");
            throw new RepositoryException("Node with a long name has been found.");
        }
    }

    static class LoggingCompositeHook
    implements CommitHook {
        private final Collection<CommitHook> hooks;
        private boolean started = false;
        private final boolean earlyShutdown;
        private final RepositoryContext source;

        public LoggingCompositeHook(Collection<CommitHook> hooks) {
            this(hooks, null, false);
        }

        public LoggingCompositeHook(Collection<CommitHook> hooks, RepositoryContext source, boolean earlyShutdown) {
            this.hooks = hooks;
            this.earlyShutdown = earlyShutdown;
            this.source = source;
        }

        @Override
        @Nonnull
        public NodeState processCommit(NodeState before, NodeState after, CommitInfo info) throws CommitFailedException {
            NodeState newState = after;
            Stopwatch watch = Stopwatch.createStarted();
            if (this.earlyShutdown && this.source != null && !this.started) {
                logger.info("Shutting down source repository.");
                this.source.getRepository().shutdown();
                this.started = true;
            }
            for (CommitHook hook : this.hooks) {
                logger.info("Processing commit via {}", (Object)hook);
                newState = hook.processCommit(before, newState, info);
                logger.info("Commit hook {} processed commit in {}", (Object)hook, (Object)watch);
                watch.reset().start();
            }
            return newState;
        }
    }
}

