/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.upgrade;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.plugins.nodetype.write.InitialContent;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.CompositeEditorProvider;
import org.apache.jackrabbit.oak.spi.commit.EditorHook;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.state.ApplyDiff;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.upgrade.IndexCopier;
import org.apache.jackrabbit.oak.upgrade.RepositoryUpgrade;
import org.apache.jackrabbit.oak.upgrade.cli.node.TarNodeStore;
import org.apache.jackrabbit.oak.upgrade.nodestate.NameFilteringNodeState;
import org.apache.jackrabbit.oak.upgrade.nodestate.NodeStateCopier;
import org.apache.jackrabbit.oak.upgrade.nodestate.report.LoggingReporter;
import org.apache.jackrabbit.oak.upgrade.nodestate.report.ReportingNodeState;
import org.apache.jackrabbit.oak.upgrade.version.VersionCopier;
import org.apache.jackrabbit.oak.upgrade.version.VersionCopyConfiguration;
import org.apache.jackrabbit.oak.upgrade.version.VersionHistoryUtil;
import org.apache.jackrabbit.oak.upgrade.version.VersionableEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositorySidegrade {
    private static final Logger LOG = LoggerFactory.getLogger(RepositorySidegrade.class);
    private static final int LOG_NODE_COPY = Integer.getInteger("oak.upgrade.logNodeCopy", 10000);
    private final NodeStore target;
    private final NodeStore source;
    private Set<String> includePaths = RepositoryUpgrade.DEFAULT_INCLUDE_PATHS;
    private Set<String> excludePaths = RepositoryUpgrade.DEFAULT_EXCLUDE_PATHS;
    private Set<String> mergePaths = RepositoryUpgrade.DEFAULT_MERGE_PATHS;
    private boolean includeIndex = false;
    private boolean filterLongNames = true;
    private boolean skipInitialization = false;
    private List<CommitHook> customCommitHooks = null;
    VersionCopyConfiguration versionCopyConfiguration = new VersionCopyConfiguration();

    public void setCopyVersions(Calendar minDate) {
        this.versionCopyConfiguration.setCopyVersions(minDate);
    }

    public void setCopyOrphanedVersions(Calendar minDate) {
        this.versionCopyConfiguration.setCopyOrphanedVersions(minDate);
    }

    public RepositorySidegrade(NodeStore source, NodeStore target) {
        this.source = source;
        this.target = target;
    }

    public List<CommitHook> getCustomCommitHooks() {
        return this.customCommitHooks;
    }

    public void setCustomCommitHooks(List<CommitHook> customCommitHooks) {
        this.customCommitHooks = customCommitHooks;
    }

    public void setIncludes(String ... includes) {
        this.includePaths = ImmutableSet.copyOf((Object[])Preconditions.checkNotNull(includes));
    }

    public void setExcludes(String ... excludes) {
        this.excludePaths = ImmutableSet.copyOf((Object[])Preconditions.checkNotNull(excludes));
    }

    public void setIncludeIndex(boolean includeIndex) {
        this.includeIndex = includeIndex;
    }

    public void setMerges(String ... merges) {
        this.mergePaths = ImmutableSet.copyOf((Object[])Preconditions.checkNotNull(merges));
    }

    public boolean isFilterLongNames() {
        return this.filterLongNames;
    }

    public void setFilterLongNames(boolean filterLongNames) {
        this.filterLongNames = filterLongNames;
    }

    public void setSkipInitialization(boolean skipInitialization) {
        this.skipInitialization = skipInitialization;
    }

    public void copy() throws RepositoryException {
        this.copy(null);
    }

    public void copy(RepositoryInitializer initializer) throws RepositoryException {
        try {
            NodeBuilder targetRoot = this.target.getRoot().builder();
            if (this.skipInitialization) {
                LOG.info("Skipping the repository initialization");
            } else {
                new InitialContent().initialize(targetRoot);
                if (initializer != null) {
                    initializer.initialize(targetRoot);
                }
            }
            NodeState reportingSourceRoot = ReportingNodeState.wrap(this.source.getRoot(), new LoggingReporter(LOG, "Copying", LOG_NODE_COPY, -1));
            NodeState sourceRoot = this.filterLongNames ? NameFilteringNodeState.wrap(reportingSourceRoot) : reportingSourceRoot;
            this.copyState(sourceRoot, targetRoot);
        }
        catch (Exception e) {
            throw new RepositoryException("Failed to copy content", e);
        }
    }

    private void removeCheckpointReferences(NodeBuilder builder) throws CommitFailedException {
        builder.setChildNode(":async");
    }

    private void copyState(NodeState sourceRoot, NodeBuilder targetRoot) throws CommitFailedException {
        this.copyWorkspace(sourceRoot, targetRoot);
        if (this.includeIndex) {
            IndexCopier.copy(sourceRoot, targetRoot, this.includePaths);
        }
        boolean isRemoveCheckpointReferences = false;
        if (!this.copyCheckpoints(targetRoot)) {
            LOG.info("Copying checkpoints is not supported for this combination of node stores");
            isRemoveCheckpointReferences = true;
        }
        if (!RepositoryUpgrade.DEFAULT_INCLUDE_PATHS.equals(this.includePaths)) {
            isRemoveCheckpointReferences = true;
        }
        if (isRemoveCheckpointReferences) {
            this.removeCheckpointReferences(targetRoot);
        }
        if (!this.versionCopyConfiguration.skipOrphanedVersionsCopy()) {
            VersionCopier.copyVersionStorage(targetRoot, VersionHistoryUtil.getVersionStorage(sourceRoot), VersionHistoryUtil.getVersionStorage(targetRoot), this.versionCopyConfiguration);
        }
        ArrayList<CommitHook> hooks = new ArrayList<CommitHook>();
        hooks.add(new EditorHook(new VersionableEditor.Provider(sourceRoot, "default", this.versionCopyConfiguration)));
        if (this.customCommitHooks != null) {
            hooks.addAll(this.customCommitHooks);
        }
        if (!this.isCompleteMigration()) {
            RepositoryUpgrade.markIndexesToBeRebuilt(targetRoot);
            hooks.add(new EditorHook(new CompositeEditorProvider(RepositoryUpgrade.createTypeEditorProvider(), RepositoryUpgrade.createIndexEditorProvider())));
        }
        this.target.merge(targetRoot, new RepositoryUpgrade.LoggingCompositeHook(hooks, null, false), CommitInfo.EMPTY);
    }

    private boolean isCompleteMigration() {
        return this.includePaths.equals(RepositoryUpgrade.DEFAULT_INCLUDE_PATHS) && this.excludePaths.equals(RepositoryUpgrade.DEFAULT_EXCLUDE_PATHS) && this.mergePaths.equals(RepositoryUpgrade.DEFAULT_MERGE_PATHS);
    }

    private void copyWorkspace(NodeState sourceRoot, NodeBuilder targetRoot) {
        Set<String> includes = RepositoryUpgrade.calculateEffectiveIncludePaths(this.includePaths, sourceRoot);
        Sets.SetView<String> excludes = Sets.union(ImmutableSet.copyOf(this.excludePaths), ImmutableSet.of("/jcr:system/jcr:versionStorage"));
        Sets.SetView<String> merges = Sets.union(ImmutableSet.copyOf(this.mergePaths), ImmutableSet.of("/jcr:system"));
        NodeStateCopier.builder().include(includes).exclude(excludes).merge(merges).copy(sourceRoot, targetRoot);
        if (this.includePaths.contains("/")) {
            NodeStateCopier.copyProperties(sourceRoot, targetRoot);
        }
    }

    private boolean copyCheckpoints(NodeBuilder targetRoot) {
        if (!(this.source instanceof TarNodeStore) || !(this.target instanceof TarNodeStore)) {
            return false;
        }
        TarNodeStore sourceTarNS = (TarNodeStore)this.source;
        TarNodeStore targetTarNS = (TarNodeStore)this.target;
        NodeState sourceSuperRoot = sourceTarNS.getSuperRoot();
        NodeBuilder targetSuperRoot = targetTarNS.getSuperRoot().builder();
        String previousCheckpoint = null;
        for (String checkpoint : RepositorySidegrade.getCheckpointNames(sourceSuperRoot)) {
            NodeState targetPreviousRoot;
            NodeState sourcePreviousRoot;
            if (previousCheckpoint == null) {
                sourcePreviousRoot = this.source.getRoot();
                targetPreviousRoot = targetRoot.getNodeState();
            } else {
                sourcePreviousRoot = RepositorySidegrade.getCheckpointRoot(sourceSuperRoot, previousCheckpoint);
                targetPreviousRoot = RepositorySidegrade.getCheckpointRoot(targetSuperRoot.getNodeState(), previousCheckpoint);
            }
            NodeState sourceCheckpoint = RepositorySidegrade.getCheckpoint(sourceSuperRoot, checkpoint);
            NodeBuilder targetCheckpoint = RepositorySidegrade.getCheckpoint(targetSuperRoot, checkpoint);
            NodeStateCopier.copyProperties(sourceCheckpoint, targetCheckpoint);
            targetCheckpoint.setChildNode("properties", sourceCheckpoint.getChildNode("properties"));
            NodeState sourceCheckpointRoot = sourceCheckpoint.getChildNode("root");
            NodeBuilder targetCheckpointRoot = targetCheckpoint.setChildNode("root", targetPreviousRoot);
            sourceCheckpointRoot.compareAgainstBaseState(sourcePreviousRoot, new ApplyDiff(targetCheckpointRoot));
            previousCheckpoint = checkpoint;
        }
        targetTarNS.setSuperRoot(targetSuperRoot);
        return true;
    }

    private static List<String> getCheckpointNames(NodeState superRoot) {
        ArrayList<? extends ChildNodeEntry> checkpoints = Lists.newArrayList(superRoot.getChildNode("checkpoints").getChildNodeEntries().iterator());
        Collections.sort(checkpoints, new Comparator<ChildNodeEntry>(){

            @Override
            public int compare(ChildNodeEntry o1, ChildNodeEntry o2) {
                long c1 = o1.getNodeState().getLong("created");
                long c2 = o1.getNodeState().getLong("created");
                return -Long.compare(c1, c2);
            }
        });
        return Lists.transform(checkpoints, new Function<ChildNodeEntry, String>(){

            @Override
            @Nullable
            public String apply(@Nullable ChildNodeEntry input) {
                return input.getName();
            }
        });
    }

    private static NodeState getCheckpointRoot(NodeState superRoot, String name) {
        return RepositorySidegrade.getCheckpoint(superRoot, name).getChildNode("root");
    }

    private static NodeState getCheckpoint(NodeState superRoot, String name) {
        return superRoot.getChildNode("checkpoints").getChildNode(name);
    }

    private static NodeBuilder getCheckpoint(NodeBuilder superRoot, String name) {
        return superRoot.child("checkpoints").child(name);
    }
}

