/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.upgrade;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.ReferenceBinary;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.persistence.util.NodePropBundle;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.memory.AbstractBlob;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.MemoryChildNodeEntry;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeBuilder;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.plugins.nodetype.TypePredicate;
import org.apache.jackrabbit.oak.spi.state.AbstractNodeState;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.upgrade.BundleLoader;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JackrabbitNodeState
extends AbstractNodeState {
    private static final Logger log = LoggerFactory.getLogger(JackrabbitNodeState.class);
    private JackrabbitNodeState parent;
    private final String name;
    private String path;
    private final BundleLoader loader;
    private final String workspaceName;
    private final TypePredicate isReferenceable;
    private final TypePredicate isOrderable;
    private final TypePredicate isVersionable;
    private final TypePredicate isVersionHistory;
    private final TypePredicate isFrozenNode;
    private final boolean skipOnError;
    private final Map<String, String> uriToPrefix;
    private final boolean useBinaryReferences;
    private final Map<String, NodeId> nodes;
    private final Map<String, PropertyState> properties;
    private final Map<NodeId, JackrabbitNodeState> mountPoints;
    private final Map<NodeId, JackrabbitNodeState> nodeStateCache;
    private final List<String> ignoredPaths = ImmutableList.of("/jcr:system/jcr:nodeTypes");

    public static JackrabbitNodeState createRootNodeState(RepositoryContext context, String workspaceName, NodeState root, Map<String, String> uriToPrefix, boolean copyBinariesByReference, boolean skipOnError) throws RepositoryException {
        ImmutableMap<NodeId, JackrabbitNodeState> emptyMountPoints = ImmutableMap.of();
        PersistenceManager versionPM = context.getInternalVersionManager().getPersistenceManager();
        JackrabbitNodeState versionStorage = new JackrabbitNodeState(versionPM, root, uriToPrefix, RepositoryImpl.VERSION_STORAGE_NODE_ID, "/jcr:system/jcr:versionStorage", null, emptyMountPoints, copyBinariesByReference, skipOnError);
        JackrabbitNodeState activities = new JackrabbitNodeState(versionPM, root, uriToPrefix, RepositoryImpl.ACTIVITIES_NODE_ID, "/jcr:system/jcr:activities", null, emptyMountPoints, copyBinariesByReference, skipOnError);
        PersistenceManager pm = context.getWorkspaceInfo(workspaceName).getPersistenceManager();
        ImmutableMap<NodeId, JackrabbitNodeState> mountPoints = ImmutableMap.of(RepositoryImpl.VERSION_STORAGE_NODE_ID, versionStorage, RepositoryImpl.ACTIVITIES_NODE_ID, activities);
        return new JackrabbitNodeState(pm, root, uriToPrefix, RepositoryImpl.ROOT_NODE_ID, "/", workspaceName, mountPoints, copyBinariesByReference, skipOnError);
    }

    private JackrabbitNodeState(JackrabbitNodeState parent, String name, NodePropBundle bundle) {
        this.parent = parent;
        this.name = name;
        this.path = null;
        this.loader = parent.loader;
        this.workspaceName = parent.workspaceName;
        this.isReferenceable = parent.isReferenceable;
        this.isOrderable = parent.isOrderable;
        this.isVersionable = parent.isVersionable;
        this.isVersionHistory = parent.isVersionHistory;
        this.isFrozenNode = parent.isFrozenNode;
        this.uriToPrefix = parent.uriToPrefix;
        this.useBinaryReferences = parent.useBinaryReferences;
        this.properties = this.createProperties(bundle);
        this.nodes = this.createNodes(bundle);
        this.skipOnError = parent.skipOnError;
        this.mountPoints = parent.mountPoints;
        this.nodeStateCache = parent.nodeStateCache;
        this.setChildOrder();
        this.fixFrozenUuid();
    }

    JackrabbitNodeState(PersistenceManager source, NodeState root, Map<String, String> uriToPrefix, NodeId id, String path, String workspaceName, Map<NodeId, JackrabbitNodeState> mountPoints, boolean useBinaryReferences, boolean skipOnError) {
        this.parent = null;
        this.name = PathUtils.getName(path);
        this.path = path;
        this.loader = new BundleLoader(source);
        this.workspaceName = workspaceName;
        this.isReferenceable = new TypePredicate(root, "mix:referenceable");
        this.isOrderable = TypePredicate.isOrderable(root);
        this.isVersionable = new TypePredicate(root, "mix:versionable");
        this.isVersionHistory = new TypePredicate(root, "nt:versionHistory");
        this.isFrozenNode = new TypePredicate(root, "nt:frozenNode");
        this.uriToPrefix = uriToPrefix;
        this.mountPoints = mountPoints;
        int cacheSize = 50;
        this.nodeStateCache = new LinkedHashMap<NodeId, JackrabbitNodeState>(50, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<NodeId, JackrabbitNodeState> eldest) {
                return this.size() >= 50;
            }
        };
        this.useBinaryReferences = useBinaryReferences;
        this.skipOnError = skipOnError;
        try {
            NodePropBundle bundle = this.loader.loadBundle(id);
            this.properties = this.createProperties(bundle);
            this.nodes = this.createNodes(bundle);
            this.setChildOrder();
        }
        catch (ItemStateException e) {
            throw new IllegalStateException("Unable to access node " + id, e);
        }
    }

    @Override
    public String toString() {
        return this.getPath();
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public long getPropertyCount() {
        return this.properties.size();
    }

    @Override
    public boolean hasProperty(@Nonnull String name) {
        return this.properties.containsKey(name);
    }

    @Override
    public PropertyState getProperty(@Nonnull String name) {
        return this.properties.get(name);
    }

    @Nonnull
    public Iterable<PropertyState> getProperties() {
        return this.properties.values();
    }

    @Override
    public long getChildNodeCount(long max) {
        return this.nodes.size();
    }

    @Override
    public boolean hasChildNode(@Nonnull String name) {
        return this.nodes.containsKey(name);
    }

    @Override
    @Nonnull
    public NodeState getChildNode(@Nonnull String name) {
        NodeId id = this.nodes.get(name);
        JackrabbitNodeState state = null;
        if (id != null) {
            state = this.createChildNodeState(id, name);
        }
        JackrabbitNodeState.checkValidName(name);
        return state != null ? state : EmptyNodeState.MISSING_NODE;
    }

    @Override
    public Iterable<String> getChildNodeNames() {
        return this.nodes.keySet();
    }

    @Nonnull
    public Iterable<MemoryChildNodeEntry> getChildNodeEntries() {
        ArrayList<MemoryChildNodeEntry> entries = Lists.newArrayListWithCapacity(this.nodes.size());
        for (Map.Entry<String, NodeId> entry : this.nodes.entrySet()) {
            String name = entry.getKey();
            JackrabbitNodeState child = this.createChildNodeState(entry.getValue(), name);
            if (child == null) continue;
            entries.add(new MemoryChildNodeEntry(name, child));
        }
        return entries;
    }

    @Override
    @Nonnull
    public NodeBuilder builder() {
        return new MemoryNodeBuilder(this);
    }

    @CheckForNull
    private JackrabbitNodeState createChildNodeState(NodeId id, String name) {
        if (this.mountPoints.containsKey(id)) {
            JackrabbitNodeState nodeState = this.mountPoints.get(id);
            Preconditions.checkState(name.equals(nodeState.name), "Expected mounted node " + id + " to be called " + nodeState.name + " instead of " + name);
            nodeState.parent = this;
            return nodeState;
        }
        JackrabbitNodeState state = this.nodeStateCache.get(id);
        if (state == null) {
            try {
                state = new JackrabbitNodeState(this, name, this.loader.loadBundle(id));
                this.nodeStateCache.put(id, state);
            }
            catch (ItemStateException e) {
                this.handleBundleLoadingException(name, e);
            }
            catch (NullPointerException e) {
                this.handleBundleLoadingException(name, e);
            }
        }
        return state;
    }

    private void handleBundleLoadingException(@Nonnull String name, Exception e) {
        if (!this.skipOnError) {
            throw new IllegalStateException("Unable to access child node " + name + " of " + this.getPath(), e);
        }
        this.warn("Skipping broken child node entry " + name + " and changing the primary type to nt:unstructured", e);
        this.properties.put("jcr:primaryType", PropertyStates.createProperty("jcr:primaryType", (Object)"nt:unstructured", Type.NAME));
    }

    private void setChildOrder() {
        if (this.isOrderable.apply(this)) {
            this.properties.put(":childOrder", PropertyStates.createProperty(":childOrder", this.nodes.keySet(), Type.NAMES));
        }
    }

    private Map<String, NodeId> createNodes(NodePropBundle bundle) {
        LinkedHashMap<String, NodeId> children = Maps.newLinkedHashMap();
        for (NodePropBundle.ChildNodeEntry entry : bundle.getChildNodeEntries()) {
            String base;
            String name = base = this.createName(entry.getName());
            int i = 2;
            while (children.containsKey(name)) {
                name = base + '[' + i + ']';
                ++i;
            }
            if (this.ignoredPaths.contains(PathUtils.concat(this.getPath(), name))) continue;
            children.put(name, entry.getId());
        }
        return children;
    }

    private Map<String, PropertyState> createProperties(NodePropBundle bundle) {
        String primary;
        HashMap<String, PropertyState> properties = Maps.newHashMap();
        if (bundle.getNodeTypeName() != null) {
            primary = this.createName(bundle.getNodeTypeName());
        } else {
            this.warn("Missing primary node type; defaulting to nt:unstructured");
            primary = "nt:unstructured";
        }
        properties.put("jcr:primaryType", PropertyStates.createProperty("jcr:primaryType", (Object)primary, Type.NAME));
        for (NodePropBundle.PropertyEntry property : bundle.getPropertyEntries()) {
            String name = this.createName(property.getName());
            try {
                int type = property.getType();
                if (property.isMultiValued()) {
                    properties.put(name, this.createProperty(name, type, property.getValues()));
                    continue;
                }
                properties.put(name, this.createProperty(name, type, property.getValues()[0]));
            }
            catch (Exception e) {
                this.warn("Skipping broken property entry " + name, e);
            }
        }
        LinkedHashSet<String> mixins = Sets.newLinkedHashSet();
        if (bundle.getMixinTypeNames() != null) {
            for (Name mixin : bundle.getMixinTypeNames()) {
                mixins.add(this.createName(mixin));
            }
        }
        if (mixins.remove("mix:simpleVersionable")) {
            mixins.add("mix:versionable");
        }
        if (!mixins.isEmpty()) {
            properties.put("jcr:mixinTypes", PropertyStates.createProperty("jcr:mixinTypes", mixins, Type.NAMES));
        }
        if (bundle.isReferenceable() || this.isReferenceable.apply(primary, mixins)) {
            properties.put("jcr:uuid", PropertyStates.createProperty("jcr:uuid", bundle.getId().toString()));
        }
        return properties;
    }

    private void fixFrozenUuid() {
        PropertyState frozenUuid = this.properties.get("jcr:frozenUuid");
        if (frozenUuid != null && frozenUuid.getType() == Type.STRING && this.isFrozenNode.apply(this)) {
            String parentFrozenUuid;
            String frozenPrimary = "nt:base";
            HashSet<String> frozenMixins = Sets.newHashSet();
            PropertyState property = this.properties.get("jcr:frozenPrimaryType");
            if (property != null && property.getType() == Type.NAME) {
                frozenPrimary = property.getValue(Type.NAME);
            }
            if ((property = this.properties.get("jcr:frozenMixinTypes")) != null && property.getType() == Type.NAMES) {
                Iterables.addAll(frozenMixins, property.getValue(Type.NAMES));
            }
            if (!this.isReferenceable.apply(frozenPrimary, frozenMixins) && (parentFrozenUuid = this.parent.getString("jcr:frozenUuid")) != null) {
                frozenUuid = PropertyStates.createProperty("jcr:frozenUuid", parentFrozenUuid + "/" + this.name);
                this.properties.put("jcr:frozenUuid", frozenUuid);
            }
        }
    }

    private PropertyState createProperty(String name, int type, InternalValue value) throws RepositoryException, IOException {
        switch (type) {
            case 2: {
                return PropertyStates.createProperty(name, this.createBlob(value), Type.BINARY);
            }
            case 6: {
                return PropertyStates.createProperty(name, value.getBoolean(), Type.BOOLEAN);
            }
            case 5: {
                return PropertyStates.createProperty(name, (Object)value.getString(), Type.DATE);
            }
            case 12: {
                return PropertyStates.createProperty(name, value.getDecimal(), Type.DECIMAL);
            }
            case 4: {
                return PropertyStates.createProperty(name, value.getDouble(), Type.DOUBLE);
            }
            case 3: {
                return PropertyStates.createProperty(name, value.getLong(), Type.LONG);
            }
            case 7: {
                return PropertyStates.createProperty(name, (Object)this.createName(value.getName()), Type.NAME);
            }
            case 8: {
                return PropertyStates.createProperty(name, (Object)this.createPath(value.getPath()), Type.PATH);
            }
            case 9: {
                return PropertyStates.createProperty(name, (Object)value.getNodeId().toString(), Type.REFERENCE);
            }
            case 1: {
                return PropertyStates.createProperty(name, (Object)value.getString(), Type.STRING);
            }
            case 11: {
                return PropertyStates.createProperty(name, (Object)value.getURI().toString(), Type.URI);
            }
            case 10: {
                return PropertyStates.createProperty(name, (Object)value.getNodeId().toString(), Type.WEAKREFERENCE);
            }
        }
        throw new RepositoryException("Unknown value type: " + type);
    }

    private PropertyState createProperty(String name, int type, InternalValue[] values) throws RepositoryException, IOException {
        switch (type) {
            case 2: {
                ArrayList<Blob> binaries = Lists.newArrayListWithCapacity(values.length);
                for (InternalValue value : values) {
                    binaries.add(this.createBlob(value));
                }
                return PropertyStates.createProperty(name, binaries, Type.BINARIES);
            }
            case 6: {
                ArrayList<Boolean> booleans = Lists.newArrayListWithCapacity(values.length);
                for (InternalValue value : values) {
                    booleans.add(value.getBoolean());
                }
                return PropertyStates.createProperty(name, booleans, Type.BOOLEANS);
            }
            case 5: {
                ArrayList<String> dates = Lists.newArrayListWithCapacity(values.length);
                for (InternalValue value : values) {
                    dates.add(value.getString());
                }
                return PropertyStates.createProperty(name, dates, Type.DATES);
            }
            case 12: {
                ArrayList<BigDecimal> decimals = Lists.newArrayListWithCapacity(values.length);
                for (InternalValue value : values) {
                    decimals.add(value.getDecimal());
                }
                return PropertyStates.createProperty(name, decimals, Type.DECIMALS);
            }
            case 4: {
                ArrayList<Double> doubles = Lists.newArrayListWithCapacity(values.length);
                for (InternalValue value : values) {
                    doubles.add(value.getDouble());
                }
                return PropertyStates.createProperty(name, doubles, Type.DOUBLES);
            }
            case 3: {
                ArrayList<Long> longs = Lists.newArrayListWithCapacity(values.length);
                for (InternalValue value : values) {
                    longs.add(value.getLong());
                }
                return PropertyStates.createProperty(name, longs, Type.LONGS);
            }
            case 7: {
                ArrayList<String> names = Lists.newArrayListWithCapacity(values.length);
                for (InternalValue value : values) {
                    names.add(this.createName(value.getName()));
                }
                return PropertyStates.createProperty(name, names, Type.NAMES);
            }
            case 8: {
                ArrayList<String> paths = Lists.newArrayListWithCapacity(values.length);
                for (InternalValue value : values) {
                    paths.add(this.createPath(value.getPath()));
                }
                return PropertyStates.createProperty(name, paths, Type.PATHS);
            }
            case 9: {
                ArrayList<String> references = Lists.newArrayListWithCapacity(values.length);
                for (InternalValue value : values) {
                    references.add(value.getNodeId().toString());
                }
                return PropertyStates.createProperty(name, references, Type.REFERENCES);
            }
            case 1: {
                ArrayList<String> strings = Lists.newArrayListWithCapacity(values.length);
                for (InternalValue value : values) {
                    strings.add(value.getString());
                }
                return PropertyStates.createProperty(name, strings, Type.STRINGS);
            }
            case 11: {
                ArrayList<String> uris = Lists.newArrayListWithCapacity(values.length);
                for (InternalValue value : values) {
                    uris.add(value.getURI().toString());
                }
                return PropertyStates.createProperty(name, uris, Type.URIS);
            }
            case 10: {
                ArrayList<String> weakreferences = Lists.newArrayListWithCapacity(values.length);
                for (InternalValue value : values) {
                    weakreferences.add(value.getNodeId().toString());
                }
                return PropertyStates.createProperty(name, weakreferences, Type.WEAKREFERENCES);
            }
        }
        throw new RepositoryException("Unknown value type: " + type);
    }

    private Blob createBlob(final InternalValue value) {
        Preconditions.checkArgument(Preconditions.checkNotNull(value).getType() == 2);
        return new AbstractBlob(){

            @Override
            public long length() {
                try {
                    return value.getLength();
                }
                catch (RepositoryException e) {
                    JackrabbitNodeState.this.warn("Unable to access blob length", e);
                    return 0L;
                }
            }

            @Override
            @Nonnull
            public InputStream getNewStream() {
                try {
                    return value.getStream();
                }
                catch (RepositoryException e) {
                    JackrabbitNodeState.this.warn("Unable to access blob contents", e);
                    return new ByteArrayInputStream(new byte[0]);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public String getReference() {
                if (!JackrabbitNodeState.this.useBinaryReferences) {
                    return null;
                }
                try {
                    Binary binary = value.getBinary();
                    try {
                        if (binary instanceof ReferenceBinary) {
                            String string = ((ReferenceBinary)binary).getReference();
                            return string;
                        }
                        String string = null;
                        return string;
                    }
                    finally {
                        binary.dispose();
                    }
                }
                catch (RepositoryException e) {
                    JackrabbitNodeState.this.warn("Unable to get blob reference", e);
                    return null;
                }
            }

            @Override
            public String getContentIdentity() {
                String reference = this.getReference();
                if (reference != null) {
                    int pos = reference.indexOf(":");
                    String blobHash = pos > -1 ? reference.substring(0, pos) : reference;
                    return blobHash + "#" + this.length();
                }
                return super.getContentIdentity();
            }
        };
    }

    private String createName(Name name) {
        String uri = name.getNamespaceURI();
        String local = name.getLocalName();
        if (uri == null || uri.isEmpty()) {
            return local;
        }
        String prefix = this.uriToPrefix.get(uri);
        if (prefix != null) {
            return prefix + ":" + local;
        }
        this.warn("No prefix mapping found for " + name);
        return "{" + uri + "}" + local;
    }

    private String createPath(Path path) throws RepositoryException {
        StringBuilder builder = new StringBuilder();
        for (Path.Element element : path.getElements()) {
            if (builder.length() > 1 || builder.length() == 1 && !"/".equals(builder.toString())) {
                builder.append('/');
            }
            if (element.denotesRoot()) {
                builder.append('/');
                continue;
            }
            if (element.denotesIdentifier()) {
                builder.append('[').append(element.getIdentifier()).append(']');
                continue;
            }
            if (element.denotesName()) {
                builder.append(this.createName(element.getName()));
                if (element.getIndex() < 1) continue;
                builder.append('[').append(element.getIndex()).append(']');
                continue;
            }
            if (element.denotesParent()) {
                builder.append("..");
                continue;
            }
            if (element.denotesCurrent()) {
                builder.append('.');
                continue;
            }
            this.warn("Unknown element in path: " + path);
            builder.append(element.getString());
        }
        return builder.toString();
    }

    private String getPath() {
        if (this.path == null) {
            this.path = PathUtils.concat(this.parent.getPath(), this.name);
        }
        return this.path;
    }

    private void warn(String message) {
        log.warn(this.getPath() + ": " + message);
    }

    private void warn(String message, Throwable cause) {
        log.warn(this.getPath() + ": " + message, cause);
    }
}

