/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.upgrade;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.upgrade.nodestate.NodeStateCopier;

public final class IndexCopier {
    private IndexCopier() {
    }

    public static void copy(NodeState sourceRoot, NodeBuilder targetRoot, Set<String> includes) {
        NodeState oakIndex = sourceRoot.getChildNode("oak:index");
        NodeBuilder targetOakIndex = IndexCopier.copySingleNode(oakIndex, targetRoot, "oak:index");
        for (ChildNodeEntry childNodeEntry : oakIndex.getChildNodeEntries()) {
            NodeState indexDef = childNodeEntry.getNodeState();
            String type = indexDef.getString("type");
            if (StringUtils.isEmpty(type)) continue;
            NodeBuilder targetIndexDef = IndexCopier.copySingleNode(childNodeEntry, targetOakIndex);
            switch (type) {
                case "property": {
                    if (indexDef.getBoolean("unique")) {
                        IndexCopier.copyUniqueIndex(indexDef, targetIndexDef, includes);
                        break;
                    }
                    IndexCopier.copyMirrorIndex(indexDef, targetIndexDef, includes);
                    break;
                }
                case "counter": {
                    IndexCopier.copyMirrorIndex(indexDef, targetIndexDef, includes);
                }
                case "lucene": {
                    IndexCopier.copyLuceneIndex(indexDef, targetIndexDef, includes);
                }
            }
        }
    }

    private static void copyUniqueIndex(NodeState indexDef, NodeBuilder targetIndexDef, Set<String> includes) {
        for (ChildNodeEntry childNodeEntry : IndexCopier.getIndexNodes(indexDef)) {
            NodeState indexNode = childNodeEntry.getNodeState();
            NodeBuilder targetIndexNode = IndexCopier.copySingleNode(indexNode, targetIndexDef, childNodeEntry.getName());
            boolean anyAttrCopied = false;
            for (ChildNodeEntry childNodeEntry2 : indexNode.getChildNodeEntries()) {
                Iterable<String> entries = childNodeEntry2.getNodeState().getStrings("entry");
                if (entries == null) continue;
                for (String e : entries) {
                    if (!IndexCopier.startsWithAny(e, includes)) continue;
                    IndexCopier.copySingleNode(childNodeEntry2, targetIndexNode);
                    anyAttrCopied = true;
                }
            }
            if (anyAttrCopied) continue;
            targetIndexNode.remove();
        }
    }

    private static void copyMirrorIndex(NodeState indexDef, NodeBuilder targetIndexDef, Set<String> includes) {
        for (ChildNodeEntry childNodeEntry : IndexCopier.getIndexNodes(indexDef)) {
            NodeState indexNode = childNodeEntry.getNodeState();
            NodeBuilder targetIndexNode = IndexCopier.copySingleNode(indexNode, targetIndexDef, childNodeEntry.getName());
            boolean anyAttrCopied = false;
            for (ChildNodeEntry childNodeEntry2 : indexNode.getChildNodeEntries()) {
                NodeBuilder targetAttr = IndexCopier.copySingleNode(childNodeEntry2, targetIndexNode);
                boolean copied = NodeStateCopier.builder().include(includes).copy(childNodeEntry2.getNodeState(), targetAttr);
                if (!copied) {
                    targetAttr.remove();
                }
                anyAttrCopied = copied || anyAttrCopied;
            }
            if (anyAttrCopied) continue;
            targetIndexNode.remove();
        }
    }

    private static Iterable<? extends ChildNodeEntry> getIndexNodes(NodeState indexDef) {
        return Iterables.filter(indexDef.getChildNodeEntries(), new Predicate<ChildNodeEntry>(){

            @Override
            public boolean apply(@Nullable ChildNodeEntry input) {
                String name = input.getName();
                return name.equals(":index") || name.startsWith(":oak:mount-");
            }
        });
    }

    private static void copyLuceneIndex(NodeState indexDef, NodeBuilder targetIndexDef, Set<String> includes) {
        NodeStateCopier.builder().include(Collections.singleton("/")).copy(indexDef, targetIndexDef);
    }

    private static NodeBuilder copySingleNode(ChildNodeEntry source, NodeBuilder targetParent) {
        return IndexCopier.copySingleNode(source.getNodeState(), targetParent, source.getName());
    }

    private static NodeBuilder copySingleNode(NodeState source, NodeBuilder targetParent, String name) {
        NodeBuilder target = targetParent.child(name);
        for (PropertyState propertyState : source.getProperties()) {
            target.setProperty(propertyState);
        }
        return target;
    }

    private static boolean startsWithAny(String subject, Iterable<String> patterns) {
        for (String p : patterns) {
            if (!subject.startsWith(p)) continue;
            return true;
        }
        return false;
    }
}

