/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.upgrade;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import org.apache.jackrabbit.commons.iterator.AbstractLazyIterator;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class DescendantsIterator
extends AbstractLazyIterator<NodeState> {
    private final Deque<Iterator<? extends ChildNodeEntry>> stack = new ArrayDeque<Iterator<? extends ChildNodeEntry>>();
    private final int maxLevel;

    public DescendantsIterator(NodeState root, int maxLevel) {
        this.maxLevel = maxLevel;
        this.stack.push(root.getChildNodeEntries().iterator());
    }

    @Override
    protected NodeState getNext() {
        if (!this.fillStack()) {
            return null;
        }
        return this.stack.peekFirst().next().getNodeState();
    }

    private boolean fillStack() {
        while (this.stack.size() < this.maxLevel || !this.stack.peekFirst().hasNext()) {
            Iterator<? extends ChildNodeEntry> topIterator = this.stack.peekFirst();
            if (topIterator.hasNext()) {
                NodeState nextNode = topIterator.next().getNodeState();
                this.stack.push(nextNode.getChildNodeEntries().iterator());
                continue;
            }
            this.stack.pop();
            if (!this.stack.isEmpty()) continue;
            return false;
        }
        return true;
    }
}

