/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.upgrade;

import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.persistence.bundle.AbstractBundlePersistenceManager;
import org.apache.jackrabbit.core.persistence.util.NodePropBundle;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;

class BundleLoader {
    private final PersistenceManager pm;
    private final Method loadBundle;

    BundleLoader(PersistenceManager pm) {
        this.pm = pm;
        Method method = null;
        if (pm instanceof AbstractBundlePersistenceManager) {
            try {
                method = AbstractBundlePersistenceManager.class.getDeclaredMethod("loadBundle", NodeId.class);
                method.setAccessible(true);
            }
            catch (SecurityException e) {
                method = null;
            }
            catch (NoSuchMethodException e) {
                method = null;
            }
        }
        this.loadBundle = method;
    }

    NodePropBundle loadBundle(NodeId id) throws ItemStateException {
        if (this.loadBundle != null) {
            try {
                return Preconditions.checkNotNull((NodePropBundle)this.loadBundle.invoke((Object)this.pm, id), "Could not load NodePropBundle for id [%s]", id);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof ItemStateException) {
                    throw (ItemStateException)e.getCause();
                }
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        NodeState state = this.pm.load(id);
        Preconditions.checkNotNull(state, "Could not load NodeState for id [%s]", id);
        NodePropBundle bundle = new NodePropBundle(state);
        for (Name name : state.getPropertyNames()) {
            if (NameConstants.JCR_UUID.equals(name)) {
                bundle.setReferenceable(true);
                continue;
            }
            if (NameConstants.JCR_PRIMARYTYPE.equals(name) || NameConstants.JCR_MIXINTYPES.equals(name)) continue;
            bundle.addProperty(new NodePropBundle.PropertyEntry(this.pm.load(new PropertyId(id, name))));
        }
        return bundle;
    }
}

