/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.stats;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.stats.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopwatchLogger
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(StopwatchLogger.class);
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private final String clazz;
    private Clock clock;
    private Logger customLog;
    private long start;

    public StopwatchLogger(@Nonnull String clazz) {
        this(null, Preconditions.checkNotNull(clazz));
    }

    public StopwatchLogger(@Nonnull Class<?> clazz) {
        this(Preconditions.checkNotNull(clazz).getName().toString());
    }

    public StopwatchLogger(@Nullable Logger customLog, @Nonnull Class<?> clazz) {
        this(customLog, Preconditions.checkNotNull(clazz).getName().toString());
    }

    public StopwatchLogger(@Nullable Logger customLog, @Nonnull String clazz) {
        this.clazz = Preconditions.checkNotNull(clazz);
        this.customLog = customLog;
    }

    public void start() {
        this.clock = new Clock.Fast(this.executor);
        this.start = this.clock.getTimeMonotonic();
    }

    public void split(@Nullable String message) {
        StopwatchLogger.track(this, message);
    }

    public void stop(@Nullable String message) {
        StopwatchLogger.track(this, message);
        this.clock = null;
    }

    private static void track(@Nonnull StopwatchLogger swl, @Nullable String message) {
        Preconditions.checkNotNull(swl);
        if (swl.isEnabled()) {
            Logger l = swl.getLogger();
            if (swl.clock == null) {
                l.debug("{} - clock has not been started yet.", (Object)swl.clazz);
            } else {
                Clock c = swl.clock;
                l.debug("{} - {} {}ms", Preconditions.checkNotNull(swl.clazz), message == null ? "" : message, c.getTimeMonotonic() - swl.start);
            }
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.executor.shutdownNow();
        }
        catch (Throwable t) {
            LOG.error("Error while shutting down the scheduler.", t);
        }
    }

    public boolean isStarted() {
        return this.clock != null;
    }

    private Logger getLogger() {
        return this.customLog == null ? LOG : this.customLog;
    }

    public boolean isEnabled() {
        return this.getLogger().isDebugEnabled();
    }
}

