/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.xml;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.plugins.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.oak.spi.xml.TextValue;

public class PropInfo {
    private final String name;
    private final int type;
    private final List<? extends TextValue> values;
    private MultipleStatus multipleStatus;

    public PropInfo(@Nullable String name, int type, @Nonnull TextValue value) {
        this(name, type, ImmutableList.of(value), MultipleStatus.UNKNOWN);
    }

    public PropInfo(@Nullable String name, int type, @Nonnull List<? extends TextValue> values) {
        this(name, type, values, values.size() == 1 ? MultipleStatus.UNKNOWN : MultipleStatus.MULTIPLE);
    }

    public PropInfo(@Nullable String name, int type, @Nonnull List<? extends TextValue> values, @Nonnull MultipleStatus multipleStatus) {
        this.name = name;
        this.type = type;
        this.values = ImmutableList.copyOf(values);
        this.multipleStatus = multipleStatus;
    }

    public void dispose() {
        for (TextValue textValue : this.values) {
            textValue.dispose();
        }
    }

    public int getTargetType(PropertyDefinition def) {
        int target = def.getRequiredType();
        if (target != 0) {
            return target;
        }
        if (this.type != 0) {
            return this.type;
        }
        return 1;
    }

    @CheckForNull
    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    @Nonnull
    public TextValue getTextValue() throws RepositoryException {
        if (this.multipleStatus == MultipleStatus.MULTIPLE) {
            throw new RepositoryException("TODO");
        }
        return this.values.get(0);
    }

    @Nonnull
    public List<? extends TextValue> getTextValues() {
        return this.values;
    }

    @Nonnull
    public Value getValue(int targetType) throws RepositoryException {
        if (this.multipleStatus == MultipleStatus.MULTIPLE) {
            throw new RepositoryException("TODO");
        }
        return this.values.get(0).getValue(targetType);
    }

    @Nonnull
    public List<Value> getValues(int targetType) throws RepositoryException {
        if (this.values.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Value> vs = Lists.newArrayListWithCapacity(this.values.size());
        for (TextValue textValue : this.values) {
            vs.add(textValue.getValue(targetType));
        }
        return vs;
    }

    public PropertyDefinition getPropertyDef(EffectiveNodeType ent) {
        int requiredType;
        Iterable<PropertyDefinition> definitions = ent.getNamedPropertyDefinitions(this.getName());
        int knownType = this.getType();
        for (PropertyDefinition def : definitions) {
            requiredType = def.getRequiredType();
            if (requiredType != 0 && knownType != 0 && requiredType != knownType || !def.isMultiple() && this.multipleStatus != MultipleStatus.UNKNOWN) continue;
            return def;
        }
        definitions = ent.getResidualPropertyDefinitions();
        for (PropertyDefinition def : definitions) {
            requiredType = def.getRequiredType();
            if (requiredType != 0 && knownType != 0 && requiredType != knownType || def.isMultiple() || this.multipleStatus != MultipleStatus.UNKNOWN) continue;
            return def;
        }
        for (PropertyDefinition def : definitions) {
            requiredType = def.getRequiredType();
            if (requiredType != 0 && knownType != 0 && requiredType != knownType || !def.isMultiple()) continue;
            return def;
        }
        return null;
    }

    public PropertyState asPropertyState(@Nonnull PropertyDefinition propertyDefinition) throws RepositoryException {
        List<Value> vs = this.getValues(this.getTargetType(propertyDefinition));
        PropertyState propertyState = vs.size() == 1 && !propertyDefinition.isMultiple() ? PropertyStates.createProperty(this.name, vs.get(0)) : PropertyStates.createProperty(this.name, vs);
        return propertyState;
    }

    public static enum MultipleStatus {
        UNKNOWN,
        MULTIPLE;

    }
}

