/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.state;

import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.management.openmbean.CompositeData;
import org.apache.jackrabbit.oak.management.ManagementOperation;
import org.apache.jackrabbit.oak.spi.state.RevisionGCMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevisionGC
implements RevisionGCMBean {
    private static final Logger log = LoggerFactory.getLogger(RevisionGC.class);
    public static final String OP_NAME = "Revision garbage collection";
    @Nonnull
    private final Runnable runGC;
    private final Runnable cancelGC;
    private final Executor executor;
    private ManagementOperation<String> gcOp = ManagementOperation.done("Revision garbage collection", "");

    public RevisionGC(@Nonnull Runnable runGC, @Nonnull Runnable cancelGC, @Nonnull Executor executor) {
        this.runGC = Preconditions.checkNotNull(runGC);
        this.cancelGC = Preconditions.checkNotNull(cancelGC);
        this.executor = Preconditions.checkNotNull(executor);
    }

    @Override
    @Nonnull
    public CompositeData startRevisionGC() {
        if (this.gcOp.isDone()) {
            this.gcOp = ManagementOperation.newManagementOperation(OP_NAME, new Callable<String>(){

                @Override
                public String call() throws Exception {
                    RevisionGC.this.runGC.run();
                    return "Revision GC initiated";
                }
            });
            this.executor.execute(this.gcOp);
        }
        return this.getRevisionGCStatus();
    }

    @Override
    @Nonnull
    public CompositeData cancelRevisionGC() {
        if (!this.gcOp.isDone()) {
            this.executor.execute(ManagementOperation.newManagementOperation(OP_NAME, new Callable<String>(){

                @Override
                public String call() throws Exception {
                    RevisionGC.this.cancelGC.run();
                    return "Revision GC cancelled";
                }
            }));
        }
        return this.getRevisionGCStatus();
    }

    @Override
    @Nonnull
    public CompositeData getRevisionGCStatus() {
        return this.gcOp.getStatus().toCompositeData();
    }
}

