/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.state;

import com.google.common.base.Predicate;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;

public interface NodeState {
    public static final Predicate<NodeState> EXISTS = new Predicate<NodeState>(){

        @Override
        public boolean apply(@Nullable NodeState input) {
            return input != null && input.exists();
        }
    };

    public boolean exists();

    public boolean hasProperty(@Nonnull String var1);

    @CheckForNull
    public PropertyState getProperty(@Nonnull String var1);

    public boolean getBoolean(@Nonnull String var1);

    public long getLong(String var1);

    @CheckForNull
    public String getString(String var1);

    @Nonnull
    public Iterable<String> getStrings(@Nonnull String var1);

    @CheckForNull
    public String getName(@Nonnull String var1);

    @Nonnull
    public Iterable<String> getNames(@Nonnull String var1);

    public long getPropertyCount();

    @Nonnull
    public Iterable<? extends PropertyState> getProperties();

    public boolean hasChildNode(@Nonnull String var1);

    @Nonnull
    public NodeState getChildNode(@Nonnull String var1) throws IllegalArgumentException;

    public long getChildNodeCount(long var1);

    public Iterable<String> getChildNodeNames();

    @Nonnull
    public Iterable<? extends ChildNodeEntry> getChildNodeEntries();

    @Nonnull
    public NodeBuilder builder();

    public boolean compareAgainstBaseState(NodeState var1, NodeStateDiff var2);
}

