/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.user.action;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.user.action.AccessControlAction;
import org.apache.jackrabbit.oak.spi.security.user.action.AuthorizableAction;
import org.apache.jackrabbit.oak.spi.security.user.action.AuthorizableActionProvider;
import org.apache.jackrabbit.oak.spi.security.user.action.ClearMembershipAction;
import org.apache.jackrabbit.oak.spi.security.user.action.PasswordChangeAction;
import org.apache.jackrabbit.oak.spi.security.user.action.PasswordValidationAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="Apache Jackrabbit Oak AuthorizableActionProvider")
@Service(value={AuthorizableActionProvider.class})
@Properties(value={@Property(name="enabledActions", label="Authorizable Actions", description="The set of actions that is supported by this provider implementation.", cardinality=4, options={@PropertyOption(name="org.apache.jackrabbit.oak.spi.security.user.action.AccessControlAction", value="AccessControlAction"), @PropertyOption(name="org.apache.jackrabbit.oak.spi.security.user.action.PasswordValidationAction", value="PasswordValidationAction"), @PropertyOption(name="org.apache.jackrabbit.oak.spi.security.user.action.PasswordChangeAction", value="PasswordChangeAction"), @PropertyOption(name="org.apache.jackrabbit.oak.spi.security.user.action.ClearMembershipAction", value="ClearMembershipAction")}), @Property(name="userPrivilegeNames", label="Configure AccessControlAction: User Privileges", description="The name of the privileges that should be granted to a given user on it's home.", cardinality=0x7FFFFFFF), @Property(name="groupPrivilegeNames", label="Configure AccessControlAction: Group Privileges", description="The name of the privileges that should be granted to a given group on it's home.", cardinality=0x7FFFFFFF), @Property(name="constraint", label="Configure PasswordValidationAction: Password Constraint", description="A regular expression specifying the pattern that must be matched by a user's password.")})
public class DefaultAuthorizableActionProvider
implements AuthorizableActionProvider {
    private static final Logger log = LoggerFactory.getLogger(DefaultAuthorizableActionProvider.class);
    private static final Map<String, Class<? extends AuthorizableAction>> SUPPORTED_ACTIONS = ImmutableMap.of(AccessControlAction.class.getName(), AccessControlAction.class, PasswordValidationAction.class.getName(), PasswordValidationAction.class, PasswordChangeAction.class.getName(), PasswordChangeAction.class, ClearMembershipAction.class.getName(), ClearMembershipAction.class);
    private static final String[] DEFAULT_ACTIONS = new String[]{AccessControlAction.class.getName()};
    static final String ENABLED_ACTIONS = "enabledActions";
    private String[] enabledActions = DEFAULT_ACTIONS;
    private ConfigurationParameters config = ConfigurationParameters.EMPTY;

    public DefaultAuthorizableActionProvider() {
    }

    public DefaultAuthorizableActionProvider(ConfigurationParameters config) {
        if (config != null) {
            this.activate(config);
        }
    }

    @Override
    @Nonnull
    public List<? extends AuthorizableAction> getAuthorizableActions(@Nonnull SecurityProvider securityProvider) {
        ArrayList<AuthorizableAction> actions = Lists.newArrayList();
        for (String className : this.enabledActions) {
            try {
                Class<? extends AuthorizableAction> cl = SUPPORTED_ACTIONS.get(className);
                if (cl == null) continue;
                AuthorizableAction action = cl.newInstance();
                action.init(securityProvider, this.config);
                actions.add(action);
            }
            catch (Exception e) {
                log.debug("Unable to create authorizable action", e);
            }
        }
        return actions;
    }

    @Activate
    private void activate(Map<String, Object> properties) {
        this.config = ConfigurationParameters.of(properties);
        this.enabledActions = this.config.getConfigValue(ENABLED_ACTIONS, DEFAULT_ACTIONS);
    }
}

