/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionDefinition;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;

public abstract class AbstractAccessControlList
implements JackrabbitAccessControlList {
    private final String oakPath;
    private final NamePathMapper namePathMapper;

    public AbstractAccessControlList(@Nullable String oakPath, @Nonnull NamePathMapper namePathMapper) {
        this.oakPath = oakPath;
        this.namePathMapper = namePathMapper;
    }

    @CheckForNull
    public String getOakPath() {
        return this.oakPath;
    }

    @Nonnull
    public NamePathMapper getNamePathMapper() {
        return this.namePathMapper;
    }

    @Nonnull
    public abstract List<? extends JackrabbitAccessControlEntry> getEntries();

    @Nonnull
    public abstract RestrictionProvider getRestrictionProvider();

    @Override
    @CheckForNull
    public String getPath() {
        return this.oakPath == null ? null : this.namePathMapper.getJcrPath(this.oakPath);
    }

    @Override
    public AccessControlEntry[] getAccessControlEntries() throws RepositoryException {
        List<? extends JackrabbitAccessControlEntry> entries = this.getEntries();
        return entries.toArray(new JackrabbitAccessControlEntry[entries.size()]);
    }

    @Override
    public boolean addAccessControlEntry(Principal principal, Privilege[] privileges) throws RepositoryException {
        return this.addEntry(principal, privileges, true, Collections.emptyMap());
    }

    @Override
    public boolean isEmpty() {
        return this.getEntries().isEmpty();
    }

    @Override
    public int size() {
        return this.getEntries().size();
    }

    @Override
    @Nonnull
    public String[] getRestrictionNames() throws RepositoryException {
        Set<RestrictionDefinition> supported = this.getRestrictionProvider().getSupportedRestrictions(this.getOakPath());
        return Collections2.transform(supported, new Function<RestrictionDefinition, String>(){

            @Override
            public String apply(RestrictionDefinition definition) {
                return AbstractAccessControlList.this.namePathMapper.getJcrName(definition.getName());
            }
        }).toArray(new String[supported.size()]);
    }

    @Override
    public int getRestrictionType(String restrictionName) throws RepositoryException {
        for (RestrictionDefinition definition : this.getRestrictionProvider().getSupportedRestrictions(this.getOakPath())) {
            String jcrName = this.namePathMapper.getJcrName(definition.getName());
            if (!jcrName.equals(restrictionName)) continue;
            return definition.getRequiredType().tag();
        }
        return 0;
    }

    @Override
    public boolean addEntry(Principal principal, Privilege[] privileges, boolean isAllow) throws RepositoryException {
        return this.addEntry(principal, privileges, isAllow, Collections.emptyMap());
    }

    @Override
    public boolean addEntry(Principal principal, Privilege[] privileges, boolean isAllow, Map<String, Value> restrictions) throws RepositoryException {
        return this.addEntry(principal, privileges, isAllow, restrictions, null);
    }
}

