/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.mount;

import java.util.Collection;
import java.util.Collections;
import org.apache.jackrabbit.oak.spi.mount.Mount;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;

public final class Mounts {
    static final MountInfoProvider DEFAULT_PROVIDER = new MountInfoProvider(){

        @Override
        public Mount getMountByPath(String path) {
            return DEFAULT_MOUNT;
        }

        @Override
        public Collection<Mount> getNonDefaultMounts() {
            return Collections.emptySet();
        }

        @Override
        public Mount getMountByName(String name) {
            return DEFAULT_MOUNT.getName().equals(name) ? DEFAULT_MOUNT : null;
        }

        @Override
        public boolean hasNonDefaultMounts() {
            return false;
        }

        @Override
        public Collection<Mount> getMountsPlacedUnder(String path) {
            return Collections.emptySet();
        }

        @Override
        public Mount getDefaultMount() {
            return DEFAULT_MOUNT;
        }
    };
    private static Mount DEFAULT_MOUNT = new DefaultMount();

    private Mounts() {
    }

    public static MountInfoProvider defaultMountInfoProvider() {
        return DEFAULT_PROVIDER;
    }

    public static Mount defaultMount() {
        return DEFAULT_MOUNT;
    }

    public static Mount defaultMount(Collection<Mount> mounts) {
        return new DefaultMount(mounts);
    }

    static final class DefaultMount
    implements Mount {
        private final Collection<Mount> mounts;

        DefaultMount() {
            this(Collections.emptySet());
        }

        DefaultMount(Collection<Mount> mounts) {
            this.mounts = mounts;
        }

        @Override
        public String getName() {
            return "";
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public boolean isDefault() {
            return true;
        }

        @Override
        public String getPathFragmentName() {
            return "";
        }

        @Override
        public boolean isMounted(String path) {
            for (Mount m : this.mounts) {
                if (!m.isMounted(path)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isUnder(String path) {
            for (Mount m : this.mounts) {
                if (!m.isMounted(path)) continue;
                return false;
            }
            return true;
        }
    }
}

