/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.gc;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.spi.gc.GCMonitor;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;

public class DelegatingGCMonitor
implements GCMonitor {
    private final Set<GCMonitor> gcMonitors = Sets.newConcurrentHashSet();

    public DelegatingGCMonitor(@Nonnull Collection<? extends GCMonitor> gcMonitors) {
        this.gcMonitors.addAll(gcMonitors);
    }

    public DelegatingGCMonitor() {
        this(Sets.newConcurrentHashSet());
    }

    public Registration registerGCMonitor(final @Nonnull GCMonitor gcMonitor) {
        this.gcMonitors.add(Preconditions.checkNotNull(gcMonitor));
        return new Registration(){

            @Override
            public void unregister() {
                DelegatingGCMonitor.this.gcMonitors.remove(gcMonitor);
            }
        };
    }

    @Override
    public void info(String message, Object ... arguments) {
        for (GCMonitor gcMonitor : this.gcMonitors) {
            gcMonitor.info(message, arguments);
        }
    }

    @Override
    public void warn(String message, Object ... arguments) {
        for (GCMonitor gcMonitor : this.gcMonitors) {
            gcMonitor.warn(message, arguments);
        }
    }

    @Override
    public void error(String message, Exception exception) {
        for (GCMonitor gcMonitor : this.gcMonitors) {
            gcMonitor.error(message, exception);
        }
    }

    @Override
    public void skipped(String reason, Object ... arguments) {
        for (GCMonitor gcMonitor : this.gcMonitors) {
            gcMonitor.skipped(reason, arguments);
        }
    }

    @Override
    public void compacted(long[] segmentCounts, long[] recordCounts, long[] compactionMapWeights) {
        for (GCMonitor gcMonitor : this.gcMonitors) {
            gcMonitor.compacted(segmentCounts, recordCounts, compactionMapWeights);
        }
    }

    @Override
    public void cleaned(long reclaimedSize, long currentSize) {
        for (GCMonitor gcMonitor : this.gcMonitors) {
            gcMonitor.cleaned(reclaimedSize, currentSize);
        }
    }
}

