/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.tool;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import org.apache.jackrabbit.oak.segment.tool.Utils;

public class Revisions
implements Runnable {
    private final File path;
    private final File out;

    public static Builder builder() {
        return new Builder();
    }

    private Revisions(Builder builder) {
        this.path = builder.path;
        this.out = builder.out;
    }

    @Override
    public void run() {
        try {
            this.listRevisions();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void listRevisions() throws IOException {
        System.out.println("Store " + this.path);
        System.out.println("Writing revisions to " + this.out);
        List<String> revs = Utils.readRevisions(this.path);
        if (revs.isEmpty()) {
            System.out.println("No revisions found.");
            return;
        }
        try (PrintWriter pw = new PrintWriter(this.out);){
            for (String r : revs) {
                pw.println(r);
            }
        }
    }

    public static class Builder {
        private File path;
        private File out;

        private Builder() {
        }

        public Builder withPath(File path) {
            this.path = Preconditions.checkNotNull(path);
            return this;
        }

        public Builder withOutput(File out) {
            this.out = Preconditions.checkNotNull(out);
            return this;
        }

        public Runnable build() {
            Preconditions.checkNotNull(this.path);
            Preconditions.checkNotNull(this.out);
            return new Revisions(this);
        }
    }
}

