/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.tool;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.io.PrintWriter;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;

final class PrintingDiff
implements NodeStateDiff {
    private static final Function<Blob, String> BLOB_LENGTH = new Function<Blob, String>(){

        @Override
        public String apply(Blob b) {
            return this.safeGetLength(b);
        }

        private String safeGetLength(Blob b) {
            try {
                return FileUtils.byteCountToDisplaySize(b.length());
            }
            catch (IllegalStateException illegalStateException) {
                return "[N/A]";
            }
        }
    };
    private final PrintWriter pw;
    private final String path;
    private final boolean skipProps;

    PrintingDiff(PrintWriter pw, String path) {
        this(pw, path, false);
    }

    private PrintingDiff(PrintWriter pw, String path, boolean skipProps) {
        this.pw = pw;
        this.path = path;
        this.skipProps = skipProps;
    }

    @Override
    public boolean propertyAdded(PropertyState after) {
        if (!this.skipProps) {
            this.pw.println("    + " + PrintingDiff.toString(after));
        }
        return true;
    }

    @Override
    public boolean propertyChanged(PropertyState before, PropertyState after) {
        if (!this.skipProps) {
            this.pw.println("    ^ " + before.getName());
            this.pw.println("      - " + PrintingDiff.toString(before));
            this.pw.println("      + " + PrintingDiff.toString(after));
        }
        return true;
    }

    @Override
    public boolean propertyDeleted(PropertyState before) {
        if (!this.skipProps) {
            this.pw.println("    - " + PrintingDiff.toString(before));
        }
        return true;
    }

    @Override
    public boolean childNodeAdded(String name, NodeState after) {
        String p = PathUtils.concat(this.path, name);
        this.pw.println("+ " + p);
        return after.compareAgainstBaseState(EmptyNodeState.EMPTY_NODE, new PrintingDiff(this.pw, p));
    }

    @Override
    public boolean childNodeChanged(String name, NodeState before, NodeState after) {
        String p = PathUtils.concat(this.path, name);
        this.pw.println("^ " + p);
        return after.compareAgainstBaseState(before, new PrintingDiff(this.pw, p));
    }

    @Override
    public boolean childNodeDeleted(String name, NodeState before) {
        String p = PathUtils.concat(this.path, name);
        this.pw.println("- " + p);
        return EmptyNodeState.MISSING_NODE.compareAgainstBaseState(before, new PrintingDiff(this.pw, p, true));
    }

    private static String toString(PropertyState ps) {
        StringBuilder val = new StringBuilder();
        val.append(ps.getName()).append("<").append(ps.getType()).append(">");
        if (ps.getType() == Type.BINARY) {
            String v = BLOB_LENGTH.apply(ps.getValue(Type.BINARY));
            val.append(" = {").append(v).append("}");
        } else if (ps.getType() == Type.BINARIES) {
            String v = Iterables.transform(ps.getValue(Type.BINARIES), BLOB_LENGTH).toString();
            val.append("[").append(ps.count()).append("] = ").append(v);
        } else if (ps.isArray()) {
            val.append("[").append(ps.count()).append("] = ").append(ps.getValue(Type.STRINGS));
        } else {
            val.append(" = ").append(ps.getValue(Type.STRING));
        }
        return ps.getName() + "<" + ps.getType() + ">" + val.toString();
    }
}

