/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.server;

import java.io.Closeable;
import java.lang.management.ManagementFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.standby.jmx.StandbyStatusMBean;
import org.apache.jackrabbit.oak.segment.standby.server.StandbyServer;
import org.apache.jackrabbit.oak.segment.standby.server.StateConsumer;
import org.apache.jackrabbit.oak.segment.standby.server.StoreProvider;
import org.apache.jackrabbit.oak.segment.standby.store.CommunicationObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandbyServerSync
implements StandbyStatusMBean,
StateConsumer,
StoreProvider,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(StandbyServer.class);
    private final FileStore fileStore;
    private final CommunicationObserver observer;
    private final int port;
    private final String[] allowedClientIPRanges;
    private final boolean secure;
    private volatile String state;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private StandbyServer server;

    public StandbyServerSync(int port, FileStore fileStore) {
        this(port, fileStore, null, false);
    }

    public StandbyServerSync(int port, FileStore fileStore, boolean secure) {
        this(port, fileStore, null, secure);
    }

    public StandbyServerSync(int port, FileStore fileStore, String[] allowedClientIPRanges) {
        this(port, fileStore, allowedClientIPRanges, false);
    }

    public StandbyServerSync(int port, FileStore fileStore, String[] allowedClientIPRanges, boolean secure) {
        this.port = port;
        this.fileStore = fileStore;
        this.allowedClientIPRanges = allowedClientIPRanges;
        this.secure = secure;
        this.observer = new CommunicationObserver("primary");
        MBeanServer jmxServer = ManagementFactory.getPlatformMBeanServer();
        try {
            jmxServer.registerMBean(new StandardMBean(this, StandbyStatusMBean.class), new ObjectName(this.getMBeanName()));
        }
        catch (Exception e) {
            log.error("can't register standby status mbean", e);
        }
    }

    @Override
    public void consumeState(String state) {
        this.state = state;
    }

    @Override
    public FileStore provideStore() {
        return this.fileStore;
    }

    @Override
    public void start() {
        if (this.isRunning()) {
            return;
        }
        this.state = "starting";
        try {
            this.server = StandbyServer.builder(this.port, this).secure(this.secure).allowIPRanges(this.allowedClientIPRanges).withStateConsumer(this).withObserver(this.observer).build();
            this.server.start();
            this.state = "running";
            this.running.set(true);
        }
        catch (Exception e) {
            log.error("Server could not be started.", e);
            this.state = null;
            this.running.set(false);
        }
    }

    @Override
    public void stop() {
        if (this.server != null) {
            this.server.stop();
        }
        this.running.set(false);
        this.state = "stopped";
    }

    @Override
    public void close() {
        this.stop();
        this.state = "closing";
        this.observer.unregister();
        MBeanServer jmxServer = ManagementFactory.getPlatformMBeanServer();
        try {
            jmxServer.unregisterMBean(new ObjectName(this.getMBeanName()));
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (Exception e) {
            log.error("can't unregister standby status mbean", e);
        }
        this.state = "closed";
    }

    @Override
    public String getMode() {
        return "primary";
    }

    @Override
    public String getStatus() {
        return this.state == null ? "initializing" : this.state;
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    public String getMBeanName() {
        return "org.apache.jackrabbit.oak:name=Status,type=\"Standby\",id=" + this.port;
    }
}

