/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.client;

import com.google.common.base.Supplier;
import java.io.Closeable;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.net.ssl.SSLException;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.standby.client.StandbyClient;
import org.apache.jackrabbit.oak.segment.standby.client.StandbyClientSyncExecution;
import org.apache.jackrabbit.oak.segment.standby.jmx.ClientStandbyStatusMBean;
import org.apache.jackrabbit.oak.segment.standby.store.CommunicationObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StandbyClientSync
implements ClientStandbyStatusMBean,
Runnable,
Closeable {
    public static final String CLIENT_ID_PROPERTY_NAME = "standbyID";
    private static final Logger log = LoggerFactory.getLogger(StandbyClientSync.class);
    private final String host;
    private final int port;
    private final int readTimeoutMs;
    private final boolean autoClean;
    private final CommunicationObserver observer;
    private final boolean secure;
    private boolean active = false;
    private int failedRequests = 0;
    private long lastSuccessfulRequest = -1L;
    private volatile String state = "initializing";
    private final Object sync = new Object();
    private final FileStore fileStore;
    private final AtomicBoolean running = new AtomicBoolean(true);
    private long syncStartTimestamp = -1L;
    private long syncEndTimestamp = -1L;

    public StandbyClientSync(String host, int port, FileStore store, boolean secure, int readTimeoutMs, boolean autoClean) throws SSLException {
        this.host = host;
        this.port = port;
        this.secure = secure;
        this.readTimeoutMs = readTimeoutMs;
        this.autoClean = autoClean;
        this.fileStore = store;
        String s = System.getProperty(CLIENT_ID_PROPERTY_NAME);
        this.observer = new CommunicationObserver(s == null || s.length() == 0 ? UUID.randomUUID().toString() : s);
        MBeanServer jmxServer = ManagementFactory.getPlatformMBeanServer();
        try {
            jmxServer.registerMBean(new StandardMBean(this, ClientStandbyStatusMBean.class), new ObjectName(this.getMBeanName()));
        }
        catch (Exception e) {
            log.error("can register standby status mbean", e);
        }
    }

    public String getMBeanName() {
        return "org.apache.jackrabbit.oak:name=Status,type=\"Standby\",id=\"" + this.observer.getID() + "\"";
    }

    @Override
    public void close() {
        this.stop();
        this.state = "closing";
        MBeanServer jmxServer = ManagementFactory.getPlatformMBeanServer();
        try {
            jmxServer.unregisterMBean(new ObjectName(this.getMBeanName()));
        }
        catch (Exception e) {
            log.error("can unregister standby status mbean", e);
        }
        this.observer.unregister();
        this.state = "closed";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.isRunning()) {
            return;
        }
        this.state = "starting";
        Object object = this.sync;
        synchronized (object) {
            if (this.active) {
                return;
            }
            this.state = "running";
            this.active = true;
        }
        try {
            long startTimestamp = System.currentTimeMillis();
            try (StandbyClient client = new StandbyClient(this.observer.getID(), this.secure, this.readTimeoutMs);){
                client.connect(this.host, this.port);
                long sizeBefore = this.fileStore.getStats().getApproximateSize();
                new StandbyClientSyncExecution(this.fileStore, client, this.newRunningSupplier()).execute();
                long sizeAfter = this.fileStore.getStats().getApproximateSize();
                if (this.autoClean && (double)sizeAfter > 1.25 * (double)sizeBefore) {
                    log.info("Store size increased from {} to {}, will run cleanup.", (Object)IOUtils.humanReadableByteCount(sizeBefore), (Object)IOUtils.humanReadableByteCount(sizeAfter));
                    this.cleanupAndRemove();
                }
            }
            this.failedRequests = 0;
            this.syncStartTimestamp = startTimestamp;
            this.syncEndTimestamp = System.currentTimeMillis();
            this.lastSuccessfulRequest = this.syncEndTimestamp / 1000L;
        }
        catch (Exception e) {
            ++this.failedRequests;
            log.error("Failed synchronizing state.", e);
        }
        finally {
            Object object2 = this.sync;
            synchronized (object2) {
                this.active = false;
            }
        }
    }

    private void cleanupAndRemove() throws IOException {
        this.fileStore.cleanup();
    }

    private Supplier<Boolean> newRunningSupplier() {
        return new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return StandbyClientSync.this.running.get();
            }
        };
    }

    @Override
    public String getMode() {
        return "client: " + this.observer.getID();
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    public void start() {
        this.running.set(true);
        this.state = "running";
    }

    @Override
    public void stop() {
        this.running.set(false);
        this.state = "stopped";
    }

    @Override
    public String getStatus() {
        return this.state;
    }

    @Override
    public int getFailedRequests() {
        return this.failedRequests;
    }

    @Override
    public int getSecondsSinceLastSuccess() {
        if (this.lastSuccessfulRequest < 0L) {
            return -1;
        }
        return (int)(System.currentTimeMillis() / 1000L - this.lastSuccessfulRequest);
    }

    @Override
    public int calcFailedRequests() {
        return this.getFailedRequests();
    }

    @Override
    public int calcSecondsSinceLastSuccess() {
        return this.getSecondsSinceLastSuccess();
    }

    @Override
    public void cleanup() {
        try {
            this.cleanupAndRemove();
        }
        catch (IOException e) {
            log.error("Error while cleaning up", e);
        }
    }

    @Override
    public long getSyncStartTimestamp() {
        return this.syncStartTimestamp;
    }

    @Override
    public long getSyncEndTimestamp() {
        return this.syncEndTimestamp;
    }
}

