/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.compression.SnappyFramedDecoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.CharsetUtil;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.segment.standby.client.GetBlobResponseHandler;
import org.apache.jackrabbit.oak.segment.standby.client.GetHeadResponseHandler;
import org.apache.jackrabbit.oak.segment.standby.client.GetReferencesResponseHandler;
import org.apache.jackrabbit.oak.segment.standby.client.GetSegmentResponseHandler;
import org.apache.jackrabbit.oak.segment.standby.codec.GetBlobRequest;
import org.apache.jackrabbit.oak.segment.standby.codec.GetBlobRequestEncoder;
import org.apache.jackrabbit.oak.segment.standby.codec.GetBlobResponse;
import org.apache.jackrabbit.oak.segment.standby.codec.GetHeadRequest;
import org.apache.jackrabbit.oak.segment.standby.codec.GetHeadRequestEncoder;
import org.apache.jackrabbit.oak.segment.standby.codec.GetHeadResponse;
import org.apache.jackrabbit.oak.segment.standby.codec.GetReferencesRequest;
import org.apache.jackrabbit.oak.segment.standby.codec.GetReferencesRequestEncoder;
import org.apache.jackrabbit.oak.segment.standby.codec.GetReferencesResponse;
import org.apache.jackrabbit.oak.segment.standby.codec.GetSegmentRequest;
import org.apache.jackrabbit.oak.segment.standby.codec.GetSegmentRequestEncoder;
import org.apache.jackrabbit.oak.segment.standby.codec.GetSegmentResponse;
import org.apache.jackrabbit.oak.segment.standby.codec.ResponseDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StandbyClient
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(StandbyClient.class);
    private final BlockingQueue<GetHeadResponse> headQueue = new LinkedBlockingDeque<GetHeadResponse>();
    private final BlockingQueue<GetSegmentResponse> segmentQueue = new LinkedBlockingDeque<GetSegmentResponse>();
    private final BlockingQueue<GetBlobResponse> blobQueue = new LinkedBlockingDeque<GetBlobResponse>();
    private final BlockingQueue<GetReferencesResponse> referencesQueue = new LinkedBlockingDeque<GetReferencesResponse>();
    private final boolean secure;
    private final int readTimeoutMs;
    private String clientId;
    private NioEventLoopGroup group;
    private Channel channel;

    StandbyClient(String clientId, boolean secure, int readTimeoutMs) {
        this.clientId = clientId;
        this.secure = secure;
        this.readTimeoutMs = readTimeoutMs;
    }

    void connect(String host, int port) throws Exception {
        this.group = new NioEventLoopGroup();
        final SslContext sslContext = this.secure ? SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build() : null;
        Bootstrap b = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)this.group)).channel(NioSocketChannel.class)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.readTimeoutMs)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                if (sslContext != null) {
                    p.addLast(new ChannelHandler[]{sslContext.newHandler(ch.alloc())});
                }
                p.addLast(new ChannelHandler[]{new ReadTimeoutHandler((long)StandbyClient.this.readTimeoutMs, TimeUnit.MILLISECONDS)});
                p.addLast(new ChannelHandler[]{new SnappyFramedDecoder(true)});
                p.addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4)});
                p.addLast(new ChannelHandler[]{new ResponseDecoder()});
                p.addLast(new ChannelHandler[]{new StringEncoder(CharsetUtil.UTF_8)});
                p.addLast(new ChannelHandler[]{new GetHeadRequestEncoder()});
                p.addLast(new ChannelHandler[]{new GetSegmentRequestEncoder()});
                p.addLast(new ChannelHandler[]{new GetBlobRequestEncoder()});
                p.addLast(new ChannelHandler[]{new GetReferencesRequestEncoder()});
                p.addLast(new ChannelHandler[]{new GetHeadResponseHandler(StandbyClient.this.headQueue)});
                p.addLast(new ChannelHandler[]{new GetSegmentResponseHandler(StandbyClient.this.segmentQueue)});
                p.addLast(new ChannelHandler[]{new GetBlobResponseHandler(StandbyClient.this.blobQueue)});
                p.addLast(new ChannelHandler[]{new GetReferencesResponseHandler(StandbyClient.this.referencesQueue)});
            }
        });
        this.channel = b.connect(host, port).sync().channel();
    }

    @Override
    public void close() throws InterruptedException {
        if (this.channel.close().awaitUninterruptibly(1L, TimeUnit.SECONDS)) {
            log.debug("Channel closed");
        } else {
            log.debug("Channel close timed out");
        }
        this.channel = null;
        if (this.group.shutdownGracefully(2L, 15L, TimeUnit.SECONDS).awaitUninterruptibly(20L, TimeUnit.SECONDS)) {
            log.debug("Group shut down");
        } else {
            log.debug("Group shutdown timed out");
        }
        this.group = null;
    }

    String getHead() throws InterruptedException {
        this.channel.writeAndFlush((Object)new GetHeadRequest(this.clientId));
        GetHeadResponse response = this.headQueue.poll(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        if (response == null) {
            return null;
        }
        return response.getHeadRecordId();
    }

    byte[] getSegment(String segmentId) throws InterruptedException {
        this.channel.writeAndFlush((Object)new GetSegmentRequest(this.clientId, segmentId));
        GetSegmentResponse response = this.segmentQueue.poll(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        if (response == null) {
            return null;
        }
        return response.getSegmentData();
    }

    byte[] getBlob(String blobId) throws InterruptedException {
        this.channel.writeAndFlush((Object)new GetBlobRequest(this.clientId, blobId));
        GetBlobResponse response = this.blobQueue.poll(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        if (response == null) {
            return null;
        }
        return response.getBlobData();
    }

    Iterable<String> getReferences(String segmentId) throws InterruptedException {
        this.channel.writeAndFlush((Object)new GetReferencesRequest(this.clientId, segmentId));
        GetReferencesResponse response = this.referencesQueue.poll(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        if (response == null) {
            return null;
        }
        return response.getReferences();
    }
}

