/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.oak.plugins.blob.ReferenceCollector;
import org.apache.jackrabbit.oak.segment.Segment;
import org.apache.jackrabbit.oak.segment.SegmentGraph;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.apache.jackrabbit.oak.segment.file.FileAccess;
import org.apache.jackrabbit.oak.segment.file.TarEntry;
import org.apache.jackrabbit.oak.segment.file.TarEntryVisitor;
import org.apache.jackrabbit.oak.segment.file.TarRecovery;
import org.apache.jackrabbit.oak.segment.file.TarWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TarReader
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(TarReader.class);
    private static final Logger GC_LOG = LoggerFactory.getLogger(TarReader.class.getName() + "-GC");
    private static final TarRecovery DEFAULT_TAR_RECOVERY = new TarRecovery(){

        @Override
        public void recoverEntry(UUID uuid, byte[] data, TarWriter writer) throws IOException {
            int generation = Segment.getGcGeneration(ByteBuffer.wrap(data), uuid);
            long msb = uuid.getMostSignificantBits();
            long lsb = uuid.getLeastSignificantBits();
            writer.writeEntry(msb, lsb, data, 0, data.length, generation);
        }
    };
    private static final int INDEX_MAGIC = 170937098;
    private static final Pattern NAME_PATTERN = Pattern.compile("([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})(\\.([0-9a-f]{8}))?(\\..*)?");
    private static final int BLOCK_SIZE = 512;
    private final File file;
    private final FileAccess access;
    private final ByteBuffer index;
    private volatile boolean closed;
    private volatile boolean hasGraph;

    static int getEntrySize(int size) {
        return 512 + size + TarWriter.getPaddingSize(size);
    }

    static TarReader open(File file, boolean memoryMapping) throws IOException {
        TarReader reader = TarReader.openFirstFileWithValidIndex(Collections.singletonList(file), memoryMapping);
        if (reader != null) {
            return reader;
        }
        throw new IOException("Failed to open tar file " + file);
    }

    static TarReader open(Map<Character, File> files, boolean memoryMapping) throws IOException {
        TreeMap<Character, File> sorted = Maps.newTreeMap();
        sorted.putAll(files);
        ArrayList<File> list = Lists.newArrayList(sorted.values());
        Collections.reverse(list);
        TarReader reader = TarReader.openFirstFileWithValidIndex(list, memoryMapping);
        if (reader != null) {
            return reader;
        }
        log.warn("Could not find a valid tar index in {}, recovering...", (Object)list);
        LinkedHashMap<UUID, byte[]> entries = Maps.newLinkedHashMap();
        for (File file : sorted.values()) {
            TarReader.collectFileEntries(file, entries, true);
        }
        File file = (File)sorted.values().iterator().next();
        TarReader.generateTarFile(entries, file, DEFAULT_TAR_RECOVERY);
        reader = TarReader.openFirstFileWithValidIndex(Collections.singletonList(file), memoryMapping);
        if (reader != null) {
            return reader;
        }
        throw new IOException("Failed to open recovered tar file " + file);
    }

    static TarReader openRO(Map<Character, File> files, boolean memoryMapping, boolean recover) throws IOException {
        File file = files.get(Collections.max(files.keySet()));
        TarReader reader = TarReader.openFirstFileWithValidIndex(Collections.singletonList(file), memoryMapping);
        if (reader != null) {
            return reader;
        }
        if (recover) {
            log.warn("Could not find a valid tar index in {}, recovering read-only", (Object)file);
            LinkedHashMap<UUID, byte[]> entries = Maps.newLinkedHashMap();
            TarReader.collectFileEntries(file, entries, false);
            file = TarReader.findAvailGen(file, ".ro.bak");
            TarReader.generateTarFile(entries, file, DEFAULT_TAR_RECOVERY);
            reader = TarReader.openFirstFileWithValidIndex(Collections.singletonList(file), memoryMapping);
            if (reader != null) {
                return reader;
            }
        }
        throw new IOException("Failed to open tar file " + file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void collectFileEntries(File file, LinkedHashMap<UUID, byte[]> entries, boolean backup) throws IOException {
        log.info("Recovering segments from tar file {}", (Object)file);
        try (RandomAccessFile access = new RandomAccessFile(file, "r");){
            TarReader.recoverEntries(file, access, entries);
        }
        catch (IOException e) {
            log.warn("Could not read tar file {}, skipping...", (Object)file, (Object)e);
        }
        if (backup) {
            TarReader.backupSafely(file);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void generateTarFile(LinkedHashMap<UUID, byte[]> entries, File file, TarRecovery recovery) throws IOException {
        log.info("Regenerating tar file {}", (Object)file);
        try (TarWriter writer = new TarWriter(file);){
            for (Map.Entry<UUID, byte[]> entry : entries.entrySet()) {
                try {
                    recovery.recoverEntry(entry.getKey(), entry.getValue(), writer);
                }
                catch (IOException e) {
                    throw new IOException(String.format("Unable to recover entry %s for file %s", entry.getKey(), file), e);
                    return;
                }
            }
        }
    }

    private static void backupSafely(File file) throws IOException {
        File backup = TarReader.findAvailGen(file, ".bak");
        log.info("Backing up {} to {}", (Object)file, (Object)backup.getName());
        if (!file.renameTo(backup)) {
            log.warn("Renaming failed, so using copy to backup {}", (Object)file);
            FileUtils.copyFile(file, backup);
            if (!file.delete()) {
                throw new IOException("Could not remove broken tar file " + file);
            }
        }
    }

    private static File findAvailGen(File file, String ext) {
        File parent = file.getParentFile();
        String name = file.getName();
        File backup = new File(parent, name + ext);
        int i = 2;
        while (backup.exists()) {
            backup = new File(parent, name + "." + i + ext);
            ++i;
        }
        return backup;
    }

    /*
     * Exception decompiling
     */
    private static TarReader openFirstFileWithValidIndex(List<File> files, boolean memoryMapping) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK], 0[TRYBLOCK], 1[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static ByteBuffer loadAndValidateIndex(RandomAccessFile file, String name) throws IOException {
        long length = file.length();
        if (length % 512L != 0L || length < 3072L || length > Integer.MAX_VALUE) {
            log.warn("Unexpected size {} of tar file {}", (Object)length, (Object)name);
            return null;
        }
        ByteBuffer meta = ByteBuffer.allocate(16);
        file.seek(length - 1024L - 16L);
        file.readFully(meta.array());
        int crc32 = meta.getInt();
        int count = meta.getInt();
        int bytes = meta.getInt();
        int magic = meta.getInt();
        if (magic != 170937098) {
            return null;
        }
        if (count < 1 || bytes < count * 28 + 16 || bytes % 512 != 0) {
            log.warn("Invalid index metadata in tar file {}", (Object)name);
            return null;
        }
        ByteBuffer index = ByteBuffer.allocate(count * 28);
        file.seek(length - 1024L - 16L - (long)(count * 28));
        file.readFully(index.array());
        index.mark();
        CRC32 checksum = new CRC32();
        long limit = length - 1024L - (long)bytes - 512L;
        long lastmsb = Long.MIN_VALUE;
        long lastlsb = Long.MIN_VALUE;
        byte[] entry = new byte[28];
        for (int i = 0; i < count; ++i) {
            index.get(entry);
            checksum.update(entry);
            ByteBuffer buffer = ByteBuffer.wrap(entry);
            long msb = buffer.getLong();
            long lsb = buffer.getLong();
            int offset = buffer.getInt();
            int size = buffer.getInt();
            if (lastmsb > msb || lastmsb == msb && lastlsb > lsb) {
                log.warn("Incorrect index ordering in tar file {}", (Object)name);
                return null;
            }
            if (lastmsb == msb && lastlsb == lsb && i > 0) {
                log.warn("Duplicate index entry in tar file {}", (Object)name);
                return null;
            }
            if (offset < 0 || offset % 512 != 0) {
                log.warn("Invalid index entry offset in tar file {}", (Object)name);
                return null;
            }
            if (size < 1 || (long)(offset + size) > limit) {
                log.warn("Invalid index entry size in tar file {}", (Object)name);
                return null;
            }
            lastmsb = msb;
            lastlsb = lsb;
        }
        if (crc32 != (int)checksum.getValue()) {
            log.warn("Invalid index checksum in tar file {}", (Object)name);
            return null;
        }
        index.reset();
        return index;
    }

    private static void recoverEntries(File file, RandomAccessFile access, LinkedHashMap<UUID, byte[]> entries) throws IOException {
        byte[] header = new byte[512];
        while (access.getFilePointer() + 512L <= access.length()) {
            int i;
            access.readFully(header);
            int sum = 0;
            for (i = 0; i < 512; ++i) {
                sum += header[i] & 0xFF;
            }
            if (sum == 0 && access.getFilePointer() + 1024L == access.length()) {
                return;
            }
            for (i = 148; i < 156; ++i) {
                sum -= header[i] & 0xFF;
                sum += 32;
            }
            byte[] checkbytes = String.format("%06o\u0000 ", sum).getBytes(Charsets.UTF_8);
            for (int i2 = 0; i2 < checkbytes.length; ++i2) {
                if (checkbytes[i2] == header[148 + i2]) continue;
                log.warn("Invalid entry checksum at offset {} in tar file {}, skipping...", (Object)(access.getFilePointer() - 512L), (Object)file);
            }
            ByteBuffer buffer = ByteBuffer.wrap(header);
            String name = TarReader.readString(buffer, 100);
            buffer.position(124);
            int size = TarReader.readNumber(buffer, 12);
            if (access.getFilePointer() + (long)size > access.length()) {
                log.warn("Partial entry {} in tar file {}, ignoring...", (Object)name, (Object)file);
                return;
            }
            Matcher matcher = NAME_PATTERN.matcher(name);
            if (matcher.matches()) {
                UUID id = UUID.fromString(matcher.group(1));
                String checksum = matcher.group(3);
                if (checksum == null && entries.containsKey(id)) continue;
                byte[] data = new byte[size];
                access.readFully(data);
                long position = access.getFilePointer();
                long remainder = position % 512L;
                if (remainder != 0L) {
                    access.seek(position + (512L - remainder));
                }
                if (checksum != null) {
                    CRC32 crc = new CRC32();
                    crc.update(data);
                    if (crc.getValue() != Long.parseLong(checksum, 16)) {
                        log.warn("Checksum mismatch in entry {} of tar file {}, skipping...", (Object)name, (Object)file);
                        continue;
                    }
                }
                entries.put(id, data);
                continue;
            }
            if (name.equals(file.getName() + ".idx")) continue;
            log.warn("Unexpected entry {} in tar file {}, skipping...", (Object)name, (Object)file);
            long position = access.getFilePointer() + (long)size;
            long remainder = position % 512L;
            if (remainder != 0L) {
                position += 512L - remainder;
            }
            access.seek(position);
        }
    }

    private TarReader(File file, FileAccess access, ByteBuffer index) {
        this.file = file;
        this.access = access;
        this.index = index;
    }

    long size() {
        return this.file.length();
    }

    int count() {
        return this.index.capacity() / 28;
    }

    void accept(TarEntryVisitor visitor) {
        for (int position = this.index.position(); position < this.index.limit(); position += 28) {
            visitor.visit(this.index.getLong(position), this.index.getLong(position + 8), this.file, this.index.getInt(position + 16), this.index.getInt(position + 20));
        }
    }

    Set<UUID> getUUIDs() {
        HashSet<UUID> uuids = Sets.newHashSetWithExpectedSize(this.index.remaining() / 28);
        for (int position = this.index.position(); position < this.index.limit(); position += 28) {
            uuids.add(new UUID(this.index.getLong(position), this.index.getLong(position + 8)));
        }
        return uuids;
    }

    boolean containsEntry(long msb, long lsb) {
        return this.findEntry(msb, lsb) != -1;
    }

    ByteBuffer readEntry(long msb, long lsb) throws IOException {
        int position = this.findEntry(msb, lsb);
        if (position != -1) {
            return this.access.read(this.index.getInt(position + 16), this.index.getInt(position + 20));
        }
        return null;
    }

    private int findEntry(long msb, long lsb) {
        int lowIndex = 0;
        int highIndex = this.index.remaining() / 28 - 1;
        float lowValue = -9.223372E18f;
        float highValue = 9.223372E18f;
        float targetValue = msb;
        while (lowIndex <= highIndex) {
            int guessIndex = lowIndex + Math.round((float)(highIndex - lowIndex) * (targetValue - lowValue) / (highValue - lowValue));
            int position = this.index.position() + guessIndex * 28;
            long m = this.index.getLong(position);
            if (msb < m) {
                highIndex = guessIndex - 1;
                highValue = m;
                continue;
            }
            if (msb > m) {
                lowIndex = guessIndex + 1;
                lowValue = m;
                continue;
            }
            long l = this.index.getLong(position + 8);
            if (lsb < l) {
                highIndex = guessIndex - 1;
                highValue = m;
                continue;
            }
            if (lsb > l) {
                lowIndex = guessIndex + 1;
                lowValue = m;
                continue;
            }
            return position;
        }
        return -1;
    }

    @Nonnull
    private TarEntry[] getEntries() {
        TarEntry[] entries = new TarEntry[this.index.remaining() / 28];
        int position = this.index.position();
        int i = 0;
        while (position < this.index.limit()) {
            entries[i] = new TarEntry(this.index.getLong(position), this.index.getLong(position + 8), this.index.getInt(position + 16), this.index.getInt(position + 20), this.index.getInt(position + 24));
            position += 28;
            ++i;
        }
        Arrays.sort(entries, TarEntry.OFFSET_ORDER);
        return entries;
    }

    @Nonnull
    private List<UUID> getReferences(TarEntry entry, UUID id, Map<UUID, List<UUID>> graph) throws IOException {
        List<UUID> references = graph.get(id);
        if (references == null) {
            return Collections.emptyList();
        }
        return references;
    }

    public void traverseSegmentGraph(@Nonnull Set<UUID> roots, @Nonnull SegmentGraph.SegmentGraphVisitor visitor) throws IOException {
        Preconditions.checkNotNull(roots);
        Preconditions.checkNotNull(visitor);
        Map<UUID, List<UUID>> graph = this.getGraph(false);
        TarEntry[] entries = this.getEntries();
        for (int i = entries.length - 1; i >= 0; --i) {
            TarEntry entry = entries[i];
            UUID id = new UUID(entry.msb(), entry.lsb());
            if (roots.remove(id) && SegmentId.isDataSegmentId(entry.lsb())) {
                for (UUID refId : this.getReferences(entry, id, graph)) {
                    visitor.accept(id, refId);
                    roots.add(refId);
                }
                continue;
            }
            visitor.accept(id, null);
        }
    }

    void calculateForwardReferences(Set<UUID> referencedIds) throws IOException {
        Map<UUID, List<UUID>> graph = this.getGraph(false);
        TarEntry[] entries = this.getEntries();
        for (int i = entries.length - 1; i >= 0; --i) {
            TarEntry entry = entries[i];
            UUID id = new UUID(entry.msb(), entry.lsb());
            if (!referencedIds.remove(id) || !SegmentId.isDataSegmentId(entry.lsb())) continue;
            referencedIds.addAll(this.getReferences(entry, id, graph));
        }
    }

    void collectBlobReferences(@Nonnull ReferenceCollector collector, @Nonnull Function<String, String> referenceDecoder, int minGeneration) {
        Map<Integer, Map<UUID, Set<String>>> generations = this.getBinaryReferences();
        if (generations == null) {
            return;
        }
        for (Map.Entry<Integer, Map<UUID, Set<String>>> entry : generations.entrySet()) {
            if (entry.getKey() < minGeneration) continue;
            for (Set<String> references : entry.getValue().values()) {
                for (String reference : references) {
                    collector.addReference(referenceDecoder.apply(reference), null);
                }
            }
        }
    }

    void mark(Set<UUID> bulkRefs, Set<UUID> reclaim, Predicate<Integer> reclaimGeneration) throws IOException {
        Map<UUID, List<UUID>> graph = this.getGraph(true);
        TarEntry[] entries = this.getEntries();
        for (int i = entries.length - 1; i >= 0; --i) {
            TarEntry entry = entries[i];
            UUID id = new UUID(entry.msb(), entry.lsb());
            if (!SegmentId.isDataSegmentId(entry.lsb()) && !bulkRefs.remove(id) || SegmentId.isDataSegmentId(entry.lsb()) && reclaimGeneration.apply(entry.generation())) {
                reclaim.add(id);
                continue;
            }
            if (!SegmentId.isDataSegmentId(entry.lsb())) continue;
            for (UUID refId : this.getReferences(entry, id, graph)) {
                if (SegmentId.isDataSegmentId(refId.getLeastSignificantBits())) continue;
                bulkRefs.add(refId);
            }
        }
    }

    TarReader sweep(@Nonnull Set<UUID> reclaim, @Nonnull Set<UUID> reclaimed) throws IOException {
        int pos;
        char generation;
        String name = this.file.getName();
        log.debug("Cleaning up {}", (Object)name);
        HashSet<UUID> cleaned = Sets.newHashSet();
        int afterSize = 0;
        int beforeSize = 0;
        int afterCount = 0;
        TarEntry[] entries = this.getEntries();
        for (int i = 0; i < entries.length; ++i) {
            TarEntry entry = entries[i];
            beforeSize += TarReader.getEntrySize(entry.size());
            UUID id = new UUID(entry.msb(), entry.lsb());
            if (reclaim.contains(id)) {
                cleaned.add(id);
                entries[i] = null;
                continue;
            }
            afterSize += TarReader.getEntrySize(entry.size());
            ++afterCount;
        }
        if (afterCount == 0) {
            log.debug("None of the entries of {} are referenceable.", (Object)name);
            this.logCleanedSegments(cleaned);
            return null;
        }
        if (afterSize >= beforeSize * 3 / 4 && this.hasGraph()) {
            log.debug("Not enough space savings. ({}/{}). Skipping clean up of {}", this.access.length() - afterSize, this.access.length(), name);
            return this;
        }
        if (!this.hasGraph()) {
            log.warn("Recovering {}, which is missing its graph.", (Object)name);
        }
        if ((generation = name.charAt(pos = name.length() - "a.tar".length())) == 'z') {
            log.debug("No garbage collection after reaching generation z: {}", (Object)name);
            return this;
        }
        File newFile = new File(this.file.getParentFile(), name.substring(0, pos) + (char)(generation + '\u0001') + ".tar");
        log.debug("Writing new generation {}", (Object)newFile.getName());
        TarWriter writer = new TarWriter(newFile);
        for (TarEntry entry : entries) {
            if (entry == null) continue;
            byte[] data = new byte[entry.size()];
            this.access.read(entry.offset(), entry.size()).get(data);
            writer.writeEntry(entry.msb(), entry.lsb(), data, 0, entry.size(), entry.generation());
        }
        Map<UUID, List<UUID>> graph = this.getGraph(false);
        for (Map.Entry<UUID, List<UUID>> e : graph.entrySet()) {
            if (cleaned.contains(e.getKey())) continue;
            HashSet<UUID> vertices = Sets.newHashSet();
            for (UUID uUID : e.getValue()) {
                if (cleaned.contains(uUID)) continue;
                vertices.add(uUID);
            }
            for (UUID uUID : vertices) {
                writer.addGraphEdge(e.getKey(), uUID);
            }
        }
        Map<Integer, Map<UUID, Set<String>>> references = this.getBinaryReferences();
        for (Map.Entry<Integer, Map<UUID, Set<String>>> ge : references.entrySet()) {
            for (Map.Entry entry : ge.getValue().entrySet()) {
                if (cleaned.contains(entry.getKey())) continue;
                for (String reference : (Set)entry.getValue()) {
                    writer.addBinaryReference(ge.getKey(), (UUID)entry.getKey(), reference);
                }
            }
        }
        writer.close();
        TarReader reader = TarReader.openFirstFileWithValidIndex(Collections.singletonList(newFile), this.access.isMemoryMapped());
        if (reader != null) {
            this.logCleanedSegments(cleaned);
            reclaimed.addAll(cleaned);
            return reader;
        }
        log.warn("Failed to open cleaned up tar file {}", (Object)this.file);
        return this;
    }

    private void logCleanedSegments(Set<UUID> cleaned) {
        StringBuilder uuids = new StringBuilder();
        String newLine = System.getProperty("line.separator", "\n") + "        ";
        int c = 0;
        String sep = "";
        for (UUID uuid : cleaned) {
            uuids.append(sep);
            if (c++ % 4 == 0) {
                uuids.append(newLine);
            }
            uuids.append(uuid);
            sep = ", ";
        }
        GC_LOG.info("TarMK cleaned segments from {}: {}", (Object)this.file.getName(), (Object)uuids);
    }

    boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.access.close();
    }

    Map<UUID, List<UUID>> getGraph(boolean bulkOnly) throws IOException {
        ByteBuffer graph = this.loadGraph();
        if (graph == null) {
            return null;
        }
        return TarReader.parseGraph(graph, bulkOnly);
    }

    private boolean hasGraph() {
        if (!this.hasGraph) {
            try {
                this.loadGraph();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.hasGraph;
    }

    private int getIndexEntrySize() {
        return TarReader.getEntrySize(this.index.remaining() + 16);
    }

    private int getGraphEntrySize() {
        ByteBuffer buffer;
        try {
            buffer = this.loadGraph();
        }
        catch (IOException e) {
            log.warn("Exception while loading pre-compiled tar graph", e);
            return 0;
        }
        if (buffer == null) {
            return 0;
        }
        return TarReader.getEntrySize(buffer.getInt(buffer.limit() - 8));
    }

    Map<Integer, Map<UUID, Set<String>>> getBinaryReferences() {
        ByteBuffer buffer;
        try {
            buffer = this.loadBinaryReferences();
        }
        catch (IOException e) {
            log.warn("Exception while loading binary reference", e);
            return null;
        }
        if (buffer == null) {
            return null;
        }
        return this.parseBinaryReferences(buffer);
    }

    private ByteBuffer loadBinaryReferences() throws IOException {
        int end = this.access.length() - 1024 - this.getIndexEntrySize() - this.getGraphEntrySize();
        ByteBuffer meta = this.access.read(end - 16, 16);
        int crc32 = meta.getInt();
        int count = meta.getInt();
        int size = meta.getInt();
        int magic = meta.getInt();
        if (magic != 170934794) {
            log.warn("Invalid binary references magic number");
            return null;
        }
        if (count < 0 || size < count * 22 + 16) {
            log.warn("Invalid binary references size or count");
            return null;
        }
        ByteBuffer buffer = this.access.read(end - size, size);
        byte[] data = new byte[size - 16];
        buffer.mark();
        buffer.get(data);
        buffer.reset();
        CRC32 checksum = new CRC32();
        checksum.update(data);
        if ((int)checksum.getValue() != crc32) {
            log.warn("Invalid binary references checksum");
            return null;
        }
        return buffer;
    }

    private Map<Integer, Map<UUID, Set<String>>> parseBinaryReferences(ByteBuffer buffer) {
        int nGenerations = buffer.getInt(buffer.limit() - 12);
        HashMap<Integer, Map<UUID, Set<String>>> binaryReferences = Maps.newHashMapWithExpectedSize(nGenerations);
        for (int i = 0; i < nGenerations; ++i) {
            int generation = buffer.getInt();
            int segmentCount = buffer.getInt();
            HashMap segments = Maps.newHashMapWithExpectedSize(segmentCount);
            for (int j = 0; j < segmentCount; ++j) {
                long msb = buffer.getLong();
                long lsb = buffer.getLong();
                int referenceCount = buffer.getInt();
                HashSet<String> references = Sets.newHashSetWithExpectedSize(referenceCount);
                for (int k = 0; k < referenceCount; ++k) {
                    int length = buffer.getInt();
                    byte[] data = new byte[length];
                    buffer.get(data);
                    references.add(new String(data, Charsets.UTF_8));
                }
                segments.put(new UUID(msb, lsb), references);
            }
            binaryReferences.put(generation, segments);
        }
        return binaryReferences;
    }

    private ByteBuffer loadGraph() throws IOException {
        int pos = this.access.length() - 1024 - this.getIndexEntrySize();
        ByteBuffer meta = this.access.read(pos - 16, 16);
        int crc32 = meta.getInt();
        int count = meta.getInt();
        int bytes = meta.getInt();
        int magic = meta.getInt();
        if (magic != 170936074) {
            log.warn("Invalid graph magic number in {}", (Object)this.file);
            return null;
        }
        if (count < 0) {
            log.warn("Invalid number of entries in {}", (Object)this.file);
            return null;
        }
        if (bytes < 4 + count * 34) {
            log.warn("Invalid entry size in {}", (Object)this.file);
            return null;
        }
        ByteBuffer graph = this.access.read(pos - bytes, bytes);
        byte[] b = new byte[bytes - 16];
        graph.mark();
        graph.get(b);
        graph.reset();
        CRC32 checksum = new CRC32();
        checksum.update(b);
        if (crc32 != (int)checksum.getValue()) {
            log.warn("Invalid graph checksum in tar file {}", (Object)this.file);
            return null;
        }
        this.hasGraph = true;
        return graph;
    }

    private static Map<UUID, List<UUID>> parseGraph(ByteBuffer buffer, boolean bulkOnly) {
        int nEntries = buffer.getInt(buffer.limit() - 12);
        HashMap<UUID, List<UUID>> graph = Maps.newHashMapWithExpectedSize(nEntries);
        for (int i = 0; i < nEntries; ++i) {
            long msb = buffer.getLong();
            long lsb = buffer.getLong();
            int nVertices = buffer.getInt();
            ArrayList<UUID> vertices = Lists.newArrayListWithCapacity(nVertices);
            for (int j = 0; j < nVertices; ++j) {
                long vmsb = buffer.getLong();
                long vlsb = buffer.getLong();
                if (bulkOnly && SegmentId.isDataSegmentId(vlsb)) continue;
                vertices.add(new UUID(vmsb, vlsb));
            }
            graph.put(new UUID(msb, lsb), vertices);
        }
        return graph;
    }

    private static String readString(ByteBuffer buffer, int fieldSize) {
        int n;
        byte[] b = new byte[fieldSize];
        buffer.get(b);
        for (n = 0; n < fieldSize && b[n] != 0; ++n) {
        }
        return new String(b, 0, n, Charsets.UTF_8);
    }

    private static int readNumber(ByteBuffer buffer, int fieldSize) {
        int digit;
        byte[] b = new byte[fieldSize];
        buffer.get(b);
        int number = 0;
        for (int i = 0; i < fieldSize && 48 <= (digit = b[i] & 0xFF) && digit <= 55; ++i) {
            number = number * 8 + digit - 48;
        }
        return number;
    }

    File getFile() {
        return this.file;
    }

    public String toString() {
        return this.file.toString();
    }
}

