/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import java.io.Closeable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.segment.file.SafeRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scheduler
implements Closeable {
    private static int schedulerNumber = 0;
    private static final Logger LOG = LoggerFactory.getLogger(Scheduler.class);
    @Nonnull
    private final AtomicLong executionCounter = new AtomicLong();
    @Nonnull
    private final String name;
    @Nonnull
    private final ScheduledExecutorService executor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scheduler(@Nullable String name) {
        if (name == null) {
            Class<Scheduler> clazz = Scheduler.class;
            synchronized (Scheduler.class) {
                this.name = "scheduler-" + schedulerNumber;
                ++schedulerNumber;
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        } else {
            this.name = name;
        }
        {
            this.executor = Executors.newScheduledThreadPool(1, new SchedulerThreadFactory(this.name));
            return;
        }
    }

    public void execute(@Nonnull String name, @Nonnull Runnable task) {
        this.executor.execute(new SafeRunnable(name, task));
    }

    public void scheduleOnce(@Nonnull String name, long delay, @Nonnull TimeUnit unit, @Nonnull Runnable task) {
        this.executor.schedule(new SafeRunnable(name, task), delay, unit);
    }

    public void scheduleAtFixedRate(@Nonnull String name, long period, @Nonnull TimeUnit unit, @Nonnull Runnable task) {
        this.executor.scheduleAtFixedRate(new SafeRunnable(name, task), period, period, unit);
    }

    @Override
    public void close() {
        try {
            this.executor.shutdown();
            if (this.executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                LOG.debug("The scheduler {} was successfully shut down", (Object)this.name);
            } else {
                LOG.warn("The scheduler {} takes too long to shutdown", (Object)this.name);
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupt while shutting down he scheduler {}", (Object)this.name, (Object)e);
            Thread.currentThread().interrupt();
        }
    }

    private static class SchedulerThreadFactory
    implements ThreadFactory {
        private final ThreadFactory threadFactory = Executors.defaultThreadFactory();
        @Nonnull
        private final String name;

        public SchedulerThreadFactory(@Nonnull String name) {
            this.name = name;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = this.threadFactory.newThread(runnable);
            thread.setName(this.name);
            thread.setDaemon(true);
            return thread;
        }
    }
}

